/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.util;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_521;
import nl.enjarai.recursiveresources.gui.ResourcePackFolderEntry;
import org.apache.commons.lang3.StringUtils;

public class ResourcePackListProcessor {
    public static final Comparator<class_521.class_4271> sortAZ = (entry1, entry2) -> String.CASE_INSENSITIVE_ORDER.compare(ResourcePackListProcessor.nameSort(entry1, false), ResourcePackListProcessor.nameSort(entry2, false));
    public static final Comparator<class_521.class_4271> sortZA = (entry1, entry2) -> -String.CASE_INSENSITIVE_ORDER.compare(ResourcePackListProcessor.nameSort(entry1, true), ResourcePackListProcessor.nameSort(entry2, true));
    private final Runnable callback;
    private int pauseCallback;
    private Comparator<class_521.class_4271> sorter;
    private Pattern textFilter;
    private String lastTextFilter;

    private static String name(class_521.class_4271 entry) {
        return entry == null ? "<INVALID>" : entry.field_19129.method_29650().getString();
    }

    private static String description(class_521.class_4271 entry) {
        return entry == null ? "<INVALID>" : entry.field_19129.method_29651().getString();
    }

    private static String nameSort(class_521.class_4271 entry, boolean reverse) {
        String pfx3;
        String pfx1 = !reverse ? "a" : "z";
        String pfx2 = !reverse ? "b" : "y";
        String string = pfx3 = !reverse ? "x" : "a";
        if (entry instanceof ResourcePackFolderEntry) {
            ResourcePackFolderEntry folder = (ResourcePackFolderEntry)entry;
            return (folder.isUp ? pfx1 : pfx2) + ResourcePackListProcessor.name(folder);
        }
        return pfx3 + ResourcePackListProcessor.name(entry);
    }

    public ResourcePackListProcessor(Runnable callback) {
        this.callback = callback;
    }

    public void pauseCallback() {
        ++this.pauseCallback;
    }

    public void resumeCallback() {
        if (this.pauseCallback > 0) {
            --this.pauseCallback;
            this.tryRunCallback();
        }
    }

    private void tryRunCallback() {
        if (this.pauseCallback == 0) {
            this.callback.run();
        }
    }

    public void setSorter(Comparator<class_521.class_4271> comparator) {
        this.sorter = comparator;
        this.tryRunCallback();
    }

    public void setFilter(String text) {
        if (!Objects.equals(text = StringUtils.trimToNull((String)text), this.lastTextFilter)) {
            this.lastTextFilter = text;
            this.textFilter = text == null ? null : Pattern.compile("\\Q" + text.replace("*", "\\E.*\\Q") + "\\E", 2);
            this.tryRunCallback();
        }
    }

    public void apply(List<class_521.class_4271> sourceList, List<class_521.class_4271> extraList, List<class_521.class_4271> targetList) {
        targetList.clear();
        this.addMatching(sourceList, targetList);
        if (extraList != null) {
            this.addMatching(extraList, targetList);
        }
        if (this.sorter != null) {
            targetList.sort(this.sorter);
        }
    }

    private void addMatching(List<class_521.class_4271> source, List<class_521.class_4271> target) {
        for (class_521.class_4271 entry : source) {
            if (!this.checkFilter(ResourcePackListProcessor.name(entry)) && !this.checkFilter(ResourcePackListProcessor.description(entry))) continue;
            target.add(entry);
        }
    }

    private boolean checkFilter(String entryText) {
        return this.textFilter == null || entryText.equals("..") || this.textFilter.matcher(entryText.toLowerCase(Locale.ENGLISH)).find();
    }
}

