/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.recursiveresources.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import nl.enjarai.recursiveresources.RecursiveResources;

public class ResourcePackUtils {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String UNSAFE_PATH_REGEX = "[<>:\"/\\\\|?*]";

    public static File[] wrap(File[] filesOrNull) {
        return filesOrNull == null ? EMPTY_FILE_ARRAY : filesOrNull;
    }

    public static boolean isFolderBasedPack(File folder) {
        return new File(folder, "pack.mcmeta").exists();
    }

    public static boolean isFolderBasedPack(Path folder) {
        return Files.exists(folder.resolve("pack.mcmeta"), new LinkOption[0]);
    }

    public static boolean isFolderButNotFolderBasedPack(File folder) {
        return folder.isDirectory() && !ResourcePackUtils.isFolderBasedPack(folder);
    }

    public static boolean isFolderButNotFolderBasedPack(Path folder) {
        return Files.isDirectory(folder, new LinkOption[0]) && !ResourcePackUtils.isFolderBasedPack(folder);
    }

    public static boolean isPack(Path fileOrFolder) {
        return Files.isDirectory(fileOrFolder, new LinkOption[0]) ? ResourcePackUtils.isFolderBasedPack(fileOrFolder) : fileOrFolder.toString().endsWith(".zip");
    }

    public static Path determinePackFolder(class_3262 pack) {
        try {
            if (pack instanceof class_3259) {
                class_3259 directoryResourcePack = (class_3259)pack;
                return directoryResourcePack.field_40001;
            }
            if (pack instanceof class_3258) {
                class_3258 zipResourcePack = (class_3258)pack;
                return zipResourcePack.field_39998.toPath();
            }
            if (pack instanceof ModNioResourcePack) {
                ModNioResourcePack modResourcePack = (ModNioResourcePack)pack;
                return Path.of(modResourcePack.method_14409().replaceAll(UNSAFE_PATH_REGEX, "_"), new String[0]);
            }
            RecursiveResources.LOGGER.warn("Failed to determine source folder for pack: " + pack.method_14409() + ", unknown pack type: " + pack.getClass().getName());
            return null;
        }
        catch (Exception e) {
            RecursiveResources.LOGGER.error("Error determining source folder for pack: " + pack.method_14409(), (Throwable)e);
            return null;
        }
    }

    public static boolean isChildOfFolder(Path folder, class_3262 pack) {
        Path packFolder = ResourcePackUtils.determinePackFolder(pack);
        return packFolder != null && packFolder.toAbsolutePath().startsWith(folder.toAbsolutePath());
    }
}

