/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunkwatching;

import com.ishland.vmp.common.chunk.sending.PlayerChunkSendingSystem;
import com.ishland.vmp.common.maps.AreaMap;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_3210;
import net.minecraft.class_3222;
import net.minecraft.class_3898;

public class AreaPlayerChunkWatchingManager
extends class_3210 {
    public static final int GENERAL_PLAYER_AREA_MAP_DISTANCE = (int)Math.ceil((double)Arrays.stream(class_1311.values()).mapToInt(class_1311::method_27919).reduce(0, Math::max) / 16.0);
    private final AreaMap<class_3222> playerAreaMap;
    private final AreaMap<class_3222> generalPlayerAreaMap = new AreaMap();
    private final Object2LongOpenHashMap<class_3222> positions = new Object2LongOpenHashMap();
    private final PlayerChunkSendingSystem playerChunkSendingSystem;
    private Listener addListener = null;
    private Listener removeListener = null;
    private int watchDistance = 5;

    public AreaPlayerChunkWatchingManager() {
        this(null, null, null);
    }

    public AreaPlayerChunkWatchingManager(Listener addListener, Listener removeListener, class_3898 tacs) {
        this.addListener = addListener;
        this.removeListener = removeListener;
        if (tacs != null) {
            this.playerChunkSendingSystem = new PlayerChunkSendingSystem(tacs);
            this.addListener = null;
            this.removeListener = null;
            this.playerAreaMap = new AreaMap(null, null, false);
        } else {
            this.playerChunkSendingSystem = null;
            this.playerAreaMap = new AreaMap<class_3222>((object, x, z) -> {
                if (this.addListener != null) {
                    this.addListener.accept((class_3222)object, x, z);
                }
            }, (object, x, z) -> {
                if (this.removeListener != null) {
                    this.removeListener.accept((class_3222)object, x, z);
                }
            }, true);
        }
    }

    public void tick() {
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.tick();
        }
    }

    public void onChunkLoaded(long pos) {
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.onChunkLoaded(pos);
        }
    }

    public void setWatchDistance(int watchDistance) {
        this.watchDistance = Math.max(3, watchDistance);
        ObjectIterator iterator = this.positions.object2LongEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            this.playerAreaMap.update((class_3222)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), this.watchDistance);
            this.generalPlayerAreaMap.update((class_3222)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), GENERAL_PLAYER_AREA_MAP_DISTANCE);
        }
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.setWatchDistance(watchDistance);
        }
    }

    public int getWatchDistance() {
        return this.watchDistance;
    }

    public Set<class_3222> method_14083(long l) {
        return this.playerAreaMap.getObjectsInRange(l);
    }

    public Object[] getPlayersWatchingChunkArray(long coordinateKey) {
        return this.playerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public Object[] getPlayersInGeneralAreaMap(long coordinateKey) {
        return this.generalPlayerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public void method_14085(long l, class_3222 player, boolean watchDisabled) {
        super.method_14085(l, player, watchDisabled);
        int x = class_1923.method_8325((long)l);
        int z = class_1923.method_8332((long)l);
        this.playerAreaMap.add(player, x, z, this.watchDistance);
        this.generalPlayerAreaMap.add(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.add(player, x, z);
        }
    }

    public void method_14084(long l, class_3222 player) {
        super.method_14084(l, player);
        this.playerAreaMap.remove(player);
        this.generalPlayerAreaMap.remove(player);
        this.positions.removeLong((Object)player);
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.remove(player);
        }
    }

    public void method_14086(class_3222 player) {
        super.method_14086(player);
    }

    public void method_14087(class_3222 player) {
        super.method_14087(player);
    }

    public boolean method_21715(class_3222 player) {
        return super.method_21715(player);
    }

    public boolean method_14082(class_3222 player) {
        return super.method_14082(player);
    }

    public void method_14081(long prevPos, long currentPos, class_3222 player) {
        int x = class_1923.method_8325((long)currentPos);
        int z = class_1923.method_8332((long)currentPos);
        this.playerAreaMap.update(player, x, z, this.watchDistance);
        this.generalPlayerAreaMap.update(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
        if (this.playerChunkSendingSystem != null) {
            this.playerChunkSendingSystem.movePlayer(player, currentPos);
        }
    }

    public static interface Listener {
        public void accept(class_3222 var1, int var2, int var3);
    }
}

