/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.goby56.wakes.WakesClient;
import com.goby56.wakes.config.enums.EffectSpawningRule;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.render.enums.BlendingFunction;
import com.goby56.wakes.render.enums.RenderType;
import com.goby56.wakes.render.enums.WakeColor;
import com.google.gson.Gson;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WakesConfig {
    public Map<String, EffectSpawningRule> effectSpawningRules = new HashMap<String, EffectSpawningRule>(Map.of("boat", EffectSpawningRule.SIMULATION_AND_PLANES, "player", EffectSpawningRule.SIMULATION_AND_PLANES, "other_players", EffectSpawningRule.SIMULATION_AND_PLANES, "mobs", EffectSpawningRule.SIMULATION_AND_PLANES, "items", EffectSpawningRule.SIMULATION_AND_PLANES));
    public boolean wakesInRunningWater = false;
    public float wavePropagationFactor = 0.95f;
    public float waveDecayFactor = 0.5f;
    public int initialStrength = 20;
    public int paddleStrength = 100;
    public int splashStrength = 100;
    public boolean spawnParticles = true;
    public boolean disableMod = false;
    public int floodFillDistance = 3;
    public boolean use9PointStencil = true;
    public int ticksBeforeFill = 2;
    public boolean drawDebugBoxes = false;
    public RenderType renderType = RenderType.AUTO;
    public Resolution wakeResolution = Resolution.SIXTEEN;
    public float wakeOpacity = 1.0f;
    public boolean useWaterBlending = true;
    public BlendingFunction blendFunc = BlendingFunction.DEFAULT;
    public GlStateManager.class_4535 srcFactor = GlStateManager.class_4535.SRC_ALPHA;
    public GlStateManager.class_4534 dstFactor = GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA;
    public List<ColorInterval> colorIntervals = List.of(new ColorInterval(WakeColor.TRANSPARENT, -50, -45), new ColorInterval(WakeColor.DARK_GRAY, -45, -35), new ColorInterval(WakeColor.GRAY, -35, -30), new ColorInterval(WakeColor.LIGHT_GRAY, -30, -15), new ColorInterval(WakeColor.TRANSPARENT, -15, 2), new ColorInterval(WakeColor.LIGHT_GRAY, 2, 10), new ColorInterval(WakeColor.WHITE, 10, 20), new ColorInterval(WakeColor.LIGHT_GRAY, 20, 40), new ColorInterval(WakeColor.GRAY, 40, 50));
    public float splashPlaneWidth = 3.0f;
    public float splashPlaneHeight = 1.5f;
    public float splashPlaneDepth = 2.0f;
    public int splashPlaneResolution = 5;
    public float maxSplashPlaneVelocity = 0.5f;
    public float splashPlaneScale = 1.0f;
    public float splashPlaneOffset = 0.0f;

    public static WakesConfig loadConfig() {
        Jankson jankson = Jankson.builder().build();
        try {
            File configFile = new File(WakesClient.CONFIG_PATH);
            if (!configFile.exists()) {
                WakesClient.LOGGER.info(String.format("No config file found for wakes-%s. Creating one...", WakesClient.METADATA.getVersion().getFriendlyString()));
                WakesConfig config = new WakesConfig();
                config.saveConfig();
                return config;
            }
            JsonObject configJson = jankson.load(configFile);
            String normalized = configJson.toJson(false, false);
            return (WakesConfig)new Gson().fromJson(normalized, WakesConfig.class);
        }
        catch (SyntaxError | IOException e) {
            e.printStackTrace();
            return new WakesConfig();
        }
    }

    public void saveConfig() {
        File configFile = new File(WakesClient.CONFIG_PATH);
        Jankson jankson = Jankson.builder().build();
        String result = jankson.toJson((Object)this).toJson(true, true);
        try {
            boolean usable;
            boolean bl = usable = configFile.exists() || configFile.createNewFile();
            if (!usable) {
                return;
            }
            FileOutputStream out = new FileOutputStream(configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ColorInterval {
        public WakeColor color;
        public int lower;
        public int upper;

        public ColorInterval(WakeColor color, int lower, int upper) {
            this.color = color;
            this.lower = lower;
            this.upper = upper;
        }

        public void setColor(WakeColor color) {
            this.color = color;
        }

        public void setLower(int lower) {
            this.lower = lower;
        }

        public void setUpper(int upper) {
            this.upper = upper;
        }
    }
}

