/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.mixin.client.playeranimation;

import com.corosus.watut.PlayerStatus;
import com.corosus.watut.WatutMod;
import com.corosus.watut.config.ConfigClient;
import com.mojang.authlib.GameProfile;
import com.zeydie.watut.playeranimation.FrameAnimation;
import com.zeydie.watut.playeranimation.IAnimation;
import com.zeydie.watut.playeranimation.PlayerAnimation;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerMixin
extends class_1657
implements IAnimation {
    @Unique
    private PlayerAnimation playerAnimation;
    @Unique
    @NotNull
    private FrameAnimation frameAnimation = FrameAnimation.NONE;

    public AbstractClientPlayerMixin(class_1937 level, class_2338 blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Unique
    @NotNull
    private class_742 getPlayer() {
        return (class_742)this;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(@NonNull class_638 level, @NonNull GameProfile profile, @NonNull CallbackInfo info) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.playerAnimation = new PlayerAnimation(this.getPlayer());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(@NonNull CallbackInfo callbackInfo) {
        if (callbackInfo == null) {
            throw new NullPointerException("callbackInfo is marked non-null but is null");
        }
        ConfigClient.showPlayerAnimations = false;
        @NonNull class_742 player = this.getPlayer();
        @NotNull PlayerStatus status = WatutMod.getPlayerStatusManagerClient().getStatus((class_1657)player);
        switch (status.getPlayerGuiState()) {
            case NONE: {
                this.frameAnimation = FrameAnimation.NONE;
                break;
            }
            case INVENTORY: {
                this.frameAnimation = FrameAnimation.INVENTORY;
                break;
            }
            case CHAT_OPEN: {
                this.frameAnimation = FrameAnimation.CHAT_OPEN;
                break;
            }
            case CHAT_TYPING: {
                this.frameAnimation = FrameAnimation.CHAT_TYPING;
                break;
            }
            case CRAFTING: {
                this.frameAnimation = FrameAnimation.CRAFTING;
                break;
            }
            case ESCAPE: {
                this.frameAnimation = FrameAnimation.ESCAPE;
                break;
            }
            case MISC: {
                this.frameAnimation = FrameAnimation.MISC;
            }
        }
        if (status.isIdle()) {
            this.frameAnimation = FrameAnimation.AFK;
        }
        if (this.frameAnimation != FrameAnimation.NONE) {
            @Nullable class_703 particle = status.getParticle();
            if (particle != null) {
                particle.method_3085();
            }
            status.setParticle(null);
        }
        this.playerAnimation.tick(this.frameAnimation);
    }

    @Override
    @Generated
    public PlayerAnimation getPlayerAnimation() {
        return this.playerAnimation;
    }

    @Override
    @Generated
    public void setFrameAnimation(@NotNull FrameAnimation frameAnimation) {
        if (frameAnimation == null) {
            throw new NullPointerException("frameAnimation is marked non-null but is null");
        }
        this.frameAnimation = frameAnimation;
    }

    @Override
    @NotNull
    @Generated
    public FrameAnimation getFrameAnimation() {
        return this.frameAnimation;
    }
}

