/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.watut.playeranimation;

import com.zeydie.watut.playeranimation.FrameAnimation;
import com.zeydie.watut.playeranimation.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import lombok.NonNull;
import net.minecraft.class_1657;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerAnimation {
    @NotNull
    private final class_742 abstractClientPlayer;
    @NotNull
    private final ModifierLayer<dev.kosmx.playerAnim.api.layered.IAnimation> modAnimationContainer = new ModifierLayer();
    @Nullable
    private KeyframeAnimation currentAnimation;
    private boolean modified = false;
    private boolean armAnimationsEnabled = true;

    public PlayerAnimation(@NonNull class_742 abstractClientPlayer) {
        if (abstractClientPlayer == null) {
            throw new NullPointerException("abstractClientPlayer is marked non-null but is null");
        }
        this.abstractClientPlayer = abstractClientPlayer;
        PlayerAnimationAccess.getPlayerAnimLayer((class_742)this.abstractClientPlayer).addAnimLayer(1000, this.modAnimationContainer);
    }

    public void tick(@NonNull FrameAnimation frameAnimation) {
        if (frameAnimation == null) {
            throw new NullPointerException("frameAnimation is marked non-null but is null");
        }
        this.playAnimation(frameAnimation.getAnimation());
    }

    private void playAnimation(@Nullable KeyframeAnimation keyframeAnimation) {
        this.playAnimation(keyframeAnimation, 1.0f, 10);
    }

    private void playAnimation(@Nullable KeyframeAnimation keyframeAnimation, float speed, int fade) {
        if (this.currentAnimation == keyframeAnimation) {
            return;
        }
        this.currentAnimation = keyframeAnimation;
        if (this.currentAnimation == null) {
            this.modAnimationContainer.setAnimation(null);
            return;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
        builder.leftArm.setEnabled(this.armAnimationsEnabled);
        builder.rightArm.setEnabled(this.armAnimationsEnabled);
        if (this.modified) {
            this.modAnimationContainer.removeModifier(0);
        }
        this.modified = true;
        this.modAnimationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(speed));
        this.modAnimationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fade, (Ease)Ease.LINEAR), (dev.kosmx.playerAnim.api.layered.IAnimation)new KeyframeAnimationPlayer(builder.build()));
        this.modAnimationContainer.setupAnim(0.05f);
    }

    private void enableArmAnimations() {
        if (this.currentAnimation != null && !this.armAnimationsEnabled) {
            this.armAnimationsEnabled = true;
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(true);
            builder.rightArm.setEnabled(true);
            this.currentAnimation = builder.build();
            if (this.modified) {
                this.modAnimationContainer.removeModifier(0);
            }
            this.modified = true;
            this.modAnimationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.abstractClientPlayer.method_6029()));
            this.modAnimationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (dev.kosmx.playerAnim.api.layered.IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
        }
    }

    private void disableArmAnimations() {
        if (this.currentAnimation != null && this.armAnimationsEnabled) {
            this.armAnimationsEnabled = false;
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull KeyframeAnimation.AnimationBuilder builder = this.currentAnimation.mutableCopy();
            builder.leftArm.setEnabled(false);
            builder.rightArm.setEnabled(false);
            this.currentAnimation = builder.build();
            if (this.modified) {
                this.modAnimationContainer.removeModifier(0);
            }
            this.modified = true;
            this.modAnimationContainer.addModifierBefore((AbstractModifier)new SpeedModifier(this.abstractClientPlayer.method_6029()));
            this.modAnimationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.LINEAR), (dev.kosmx.playerAnim.api.layered.IAnimation)new KeyframeAnimationPlayer(this.currentAnimation));
            this.modAnimationContainer.setupAnim(0.05f);
            this.modAnimationContainer.tick();
        }
    }

    public static boolean hasAnimation(@NonNull class_1657 player) {
        class_742 abstractClientPlayer;
        IAnimation ianimation;
        FrameAnimation frame;
        KeyframeAnimation animation;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return player instanceof class_742 && (animation = (frame = (ianimation = (IAnimation)(abstractClientPlayer = (class_742)player)).getFrameAnimation()).getAnimation()) != null;
    }
}

