/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class SerializationConfigurationLambdaCapturingType
implements JsonPrintable {
    private final ConfigurationCondition condition;
    private final String qualifiedJavaName;

    public SerializationConfigurationLambdaCapturingType(ConfigurationCondition condition, String qualifiedJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not the internal representation";
        Objects.requireNonNull(condition);
        this.condition = condition;
        Objects.requireNonNull(qualifiedJavaName);
        this.qualifiedJavaName = qualifiedJavaName;
    }

    public ConfigurationCondition getCondition() {
        return this.condition;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer);
        writer.quote("name").append(":").quote(this.qualifiedJavaName);
        writer.unindent().newline().append('}');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationLambdaCapturingType that = (SerializationConfigurationLambdaCapturingType)o;
        return this.condition.equals((Object)that.condition) && this.qualifiedJavaName.equals(that.qualifiedJavaName);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.qualifiedJavaName);
    }

    public static final class SerializationConfigurationLambdaCapturingTypesComparator
    implements Comparator<SerializationConfigurationLambdaCapturingType> {
        @Override
        public int compare(SerializationConfigurationLambdaCapturingType o1, SerializationConfigurationLambdaCapturingType o2) {
            int compareName = o1.qualifiedJavaName.compareTo(o2.qualifiedJavaName);
            if (compareName != 0) {
                return compareName;
            }
            return o1.condition.compareTo(o2.condition);
        }
    }
}

