/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.filters.ConfigurationFilter;
import com.oracle.svm.configure.filters.FilterConfigurationParser;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.graalvm.collections.EconomicMap;

public class RegexFilter
implements ConfigurationFilter {
    private final Pattern[][] regexPatterns = new Pattern[ConfigurationFilter.Inclusion.values().length][];

    public RegexFilter() {
        for (ConfigurationFilter.Inclusion inclusion : ConfigurationFilter.Inclusion.values()) {
            this.regexPatterns[inclusion.ordinal()] = new Pattern[0];
        }
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.quote("regexRules").append(": [").indent().newline();
        boolean[] first = new boolean[]{true};
        for (ConfigurationFilter.Inclusion inclusion : ConfigurationFilter.Inclusion.values()) {
            for (Pattern pattern : this.regexPatterns[inclusion.ordinal()]) {
                FilterConfigurationParser.printEntry(writer, first, inclusion, pattern.pattern());
            }
        }
        writer.unindent().newline();
        writer.append("]");
    }

    @Override
    public void parseFromJson(EconomicMap<String, Object> topJsonObject) {
        Object regexRules = topJsonObject.get((Object)"regexRules");
        if (regexRules != null) {
            List patternList = ConfigurationParser.asList((Object)regexRules, (String)"Field 'regexRules' must be a list of objects.");
            List[] patterns = new List[ConfigurationFilter.Inclusion.values().length];
            for (ConfigurationFilter.Inclusion inclusion2 : ConfigurationFilter.Inclusion.values()) {
                patterns[inclusion2.ordinal()] = new ArrayList<Pattern>(Arrays.asList(this.regexPatterns[inclusion2.ordinal()]));
            }
            for (Object patternObject : patternList) {
                FilterConfigurationParser.parseEntry(patternObject, (pattern, inclusion) -> patterns[inclusion.ordinal()].add(Pattern.compile(pattern)));
            }
            for (ConfigurationFilter.Inclusion inclusion3 : ConfigurationFilter.Inclusion.values()) {
                this.regexPatterns[inclusion3.ordinal()] = patterns[inclusion3.ordinal()].toArray(new Pattern[0]);
            }
        }
    }

    private boolean matchesForInclusion(ConfigurationFilter.Inclusion inclusion, String qualifiedName) {
        for (Pattern p : this.regexPatterns[inclusion.ordinal()]) {
            if (!p.matcher(qualifiedName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean includes(String qualifiedName) {
        if (this.regexPatterns[ConfigurationFilter.Inclusion.Include.ordinal()].length != 0 && !this.matchesForInclusion(ConfigurationFilter.Inclusion.Include, qualifiedName)) {
            return false;
        }
        if (this.regexPatterns[ConfigurationFilter.Inclusion.Exclude.ordinal()].length != 0) {
            return !this.matchesForInclusion(ConfigurationFilter.Inclusion.Exclude, qualifiedName);
        }
        return true;
    }
}

