/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OrtProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OnnxRuntime {
    private static final Logger logger = Logger.getLogger(OnnxRuntime.class.getName());
    private static final int ORT_API_VERSION_1 = 1;
    private static final int ORT_API_VERSION_2 = 2;
    private static final int ORT_API_VERSION_3 = 3;
    private static final int ORT_API_VERSION_7 = 7;
    private static final int ORT_API_VERSION_8 = 8;
    private static final int ORT_API_VERSION_11 = 11;
    static final String ONNXRUNTIME_NATIVE_PATH = "onnxruntime.native.path";
    static final String ONNXRUNTIME_LIBRARY_NAME = "onnxruntime";
    static final String ONNXRUNTIME_JNI_LIBRARY_NAME = "onnxruntime4j_jni";
    static final String ONNXRUNTIME_LIBRARY_SHARED_NAME = "onnxruntime_providers_shared";
    static final String ONNXRUNTIME_LIBRARY_CUDA_NAME = "onnxruntime_providers_cuda";
    static final String ONNXRUNTIME_LIBRARY_ROCM_NAME = "onnxruntime_providers_rocm";
    static final String ONNXRUNTIME_LIBRARY_DNNL_NAME = "onnxruntime_providers_dnnl";
    static final String ONNXRUNTIME_LIBRARY_OPENVINO_NAME = "onnxruntime_providers_openvino";
    static final String ONNXRUNTIME_LIBRARY_TENSORRT_NAME = "onnxruntime_providers_tensorrt";
    private static final String OS_ARCH_STR = OnnxRuntime.initOsArch();
    private static boolean loaded = false;
    private static Path tempDirectory;
    private static String libraryDirPathProperty;
    private static final Set<String> extractedSharedProviders;
    static long ortApiHandle;
    static EnumSet<OrtProvider> providers;

    private OnnxRuntime() {
    }

    private static String initOsArch() {
        String string = null;
        String string2 = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (string2.contains("mac") || string2.contains("darwin")) {
            string = "osx";
        } else if (string2.contains("win")) {
            string = "win";
        } else if (string2.contains("nux")) {
            string = "linux";
        } else if (OnnxRuntime.isAndroid()) {
            string = "android";
        } else {
            throw new IllegalStateException("Unsupported os:" + string2);
        }
        String string3 = null;
        String string4 = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (string4.startsWith("amd64") || string4.startsWith("x86_64")) {
            string3 = "x64";
        } else if (string4.startsWith("x86")) {
            string3 = "x86";
        } else if (string4.startsWith("aarch64")) {
            string3 = "aarch64";
        } else if (string4.startsWith("ppc64")) {
            string3 = "ppc64";
        } else if (OnnxRuntime.isAndroid()) {
            string3 = string4;
        } else {
            throw new IllegalStateException("Unsupported arch:" + string4);
        }
        return string + '-' + string3;
    }

    static synchronized void init() throws IOException {
        if (loaded) {
            return;
        }
        tempDirectory = OnnxRuntime.isAndroid() ? null : Files.createTempDirectory("onnxruntime-java", new FileAttribute[0]);
        try {
            libraryDirPathProperty = System.getProperty(ONNXRUNTIME_NATIVE_PATH);
            OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_SHARED_NAME);
            OnnxRuntime.load(ONNXRUNTIME_LIBRARY_NAME);
            OnnxRuntime.load(ONNXRUNTIME_JNI_LIBRARY_NAME);
            ortApiHandle = OnnxRuntime.initialiseAPIBase(11);
            providers = OnnxRuntime.initialiseProviders(ortApiHandle);
            loaded = true;
        }
        finally {
            if (tempDirectory != null) {
                OnnxRuntime.cleanUp(tempDirectory.toFile());
            }
        }
    }

    private static void cleanUp(File file) {
        if (!file.exists()) {
            return;
        }
        logger.log(Level.FINE, "Deleting " + file + " on exit");
        file.deleteOnExit();
    }

    static boolean extractCUDA() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_CUDA_NAME);
    }

    static boolean extractROCM() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_ROCM_NAME);
    }

    static boolean extractDNNL() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_DNNL_NAME);
    }

    static boolean extractOpenVINO() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_OPENVINO_NAME);
    }

    static boolean extractTensorRT() {
        return OnnxRuntime.extractProviderLibrary(ONNXRUNTIME_LIBRARY_TENSORRT_NAME);
    }

    static synchronized boolean extractProviderLibrary(String string) {
        if (OnnxRuntime.isAndroid()) {
            return false;
        }
        if (extractedSharedProviders.contains(string)) {
            return true;
        }
        Optional<File> optional = OnnxRuntime.extractFromResources(string);
        if (optional.isPresent()) {
            extractedSharedProviders.add(string);
            return true;
        }
        if (libraryDirPathProperty != null) {
            String string2 = OnnxRuntime.mapLibraryName(string);
            File file = Paths.get(libraryDirPathProperty, string2).toFile();
            if (file.exists()) {
                extractedSharedProviders.add(string);
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean isAndroid() {
        return System.getProperty("java.vendor", "generic").equals("The Android Project");
    }

    private static void load(String string) throws IOException {
        if (OnnxRuntime.isAndroid()) {
            System.loadLibrary(ONNXRUNTIME_JNI_LIBRARY_NAME);
            return;
        }
        String string2 = System.getProperty("onnxruntime.native." + string + ".skip");
        if (Boolean.TRUE.toString().equalsIgnoreCase(string2)) {
            logger.log(Level.FINE, "Skipping load of native library '" + string + "'");
            return;
        }
        String string3 = OnnxRuntime.mapLibraryName(string);
        if (libraryDirPathProperty != null) {
            logger.log(Level.FINE, "Attempting to load native library '" + string + "' from specified path: " + libraryDirPathProperty);
            File file = Paths.get(libraryDirPathProperty, string3).toFile();
            String string4 = file.getAbsolutePath();
            if (!file.exists()) {
                throw new IOException("Native library '" + string + "' not found at " + string4);
            }
            System.load(string4);
            logger.log(Level.FINE, "Loaded native library '" + string + "' from specified path");
            return;
        }
        String string5 = System.getProperty("onnxruntime.native." + string + ".path");
        if (string5 != null) {
            logger.log(Level.FINE, "Attempting to load native library '" + string + "' from specified path: " + string5);
            File file = new File(string5);
            String string6 = file.getAbsolutePath();
            if (!file.exists()) {
                throw new IOException("Native library '" + string + "' not found at " + string6);
            }
            System.load(string6);
            logger.log(Level.FINE, "Loaded native library '" + string + "' from specified path");
            return;
        }
        Optional<File> optional = OnnxRuntime.extractFromResources(string);
        if (optional.isPresent()) {
            System.load(optional.get().getAbsolutePath());
            logger.log(Level.FINE, "Loaded native library '" + string + "' from resource path");
        } else {
            logger.log(Level.FINE, "Attempting to load native library '" + string + "' from library path");
            System.loadLibrary(string);
            logger.log(Level.FINE, "Loaded native library '" + string + "' from library path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<File> extractFromResources(String string) {
        String string2 = OnnxRuntime.mapLibraryName(string);
        String string3 = "/ai/onnxruntime/native/" + OS_ARCH_STR + '/' + string2;
        File file = tempDirectory.resolve(string2).toFile();
        try {
            Object object;
            block22: {
                InputStream inputStream;
                block19: {
                    Optional<File> optional;
                    block20: {
                        inputStream = OnnxRuntime.class.getResourceAsStream(string3);
                        if (inputStream != null) break block19;
                        optional = Optional.empty();
                        if (inputStream == null) break block20;
                        inputStream.close();
                    }
                    return optional;
                }
                try {
                    logger.log(Level.FINE, "Attempting to load native library '" + string + "' from resource path " + string3 + " copying to " + file);
                    byte[] byArray = new byte[4096];
                    object = new FileOutputStream(file);
                    try {
                        int n2;
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            ((FileOutputStream)object).write(byArray, 0, n2);
                        }
                    }
                    finally {
                        ((FileOutputStream)object).close();
                    }
                    logger.log(Level.FINE, "Extracted native library '" + string + "' from resource path");
                    object = Optional.of(file);
                    if (inputStream == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        logger.log(Level.WARNING, "Failed to extract library '" + string + "' from the resources", iOException);
                        Optional<File> optional = Optional.empty();
                        return optional;
                    }
                }
                inputStream.close();
            }
            return object;
        }
        finally {
            OnnxRuntime.cleanUp(file);
        }
    }

    private static String mapLibraryName(String string) {
        return System.mapLibraryName(string).replace("jnilib", "dylib");
    }

    private static EnumSet<OrtProvider> initialiseProviders(long l2) {
        String[] stringArray = OnnxRuntime.getAvailableProviders(l2);
        EnumSet<OrtProvider> enumSet = EnumSet.noneOf(OrtProvider.class);
        for (String string : stringArray) {
            enumSet.add(OrtProvider.mapFromName(string));
        }
        return enumSet;
    }

    private static native long initialiseAPIBase(int var0);

    private static native String[] getAvailableProviders(long var0);

    static {
        extractedSharedProviders = new HashSet<String>();
    }
}

