/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.util.logging.Logger;

public enum OrtLoggingLevel {
    ORT_LOGGING_LEVEL_VERBOSE(0),
    ORT_LOGGING_LEVEL_INFO(1),
    ORT_LOGGING_LEVEL_WARNING(2),
    ORT_LOGGING_LEVEL_ERROR(3),
    ORT_LOGGING_LEVEL_FATAL(4);

    private final int value;
    private static final Logger logger;
    private static final OrtLoggingLevel[] values;

    private OrtLoggingLevel(int n3) {
        this.value = n3;
    }

    public int getValue() {
        return this.value;
    }

    public static OrtLoggingLevel mapFromInt(int n2) {
        if (n2 > 0 && n2 < values.length) {
            return values[n2];
        }
        logger.warning("Unknown logging level " + n2 + " setting to ORT_LOGGING_LEVEL_VERBOSE");
        return ORT_LOGGING_LEVEL_VERBOSE;
    }

    static {
        logger = Logger.getLogger(OrtLoggingLevel.class.getName());
        values = new OrtLoggingLevel[5];
        OrtLoggingLevel[] ortLoggingLevelArray = OrtLoggingLevel.values();
        int n2 = ortLoggingLevelArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            OrtLoggingLevel ortLoggingLevel;
            OrtLoggingLevel.values[ortLoggingLevel.value] = ortLoggingLevel = ortLoggingLevelArray[i2];
        }
    }
}

