/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.hybrid;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.ArrayUtil;
import com.oracle.svm.enterprise.core.hybrid.o;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class a
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor gc = SnippetRuntime.findForeignCall(a.class, (String)"doHybridByteArraycopy", (boolean)false, (LocationIdentity[])new LocationIdentity[]{NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte)});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor gd = SnippetRuntime.findForeignCall(a.class, (String)"doHybridByteArraycopyNonThrowing", (boolean)true, (LocationIdentity[])new LocationIdentity[]{NamedLocationIdentity.getArrayLocation((JavaKind)JavaKind.Byte)});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] ge = new SnippetRuntime.SubstrateForeignCallDescriptor[]{gc, gd};
    private final SnippetTemplate.SnippetInfo gf;

    public static void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(ge);
    }

    public a(OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
        super(optionValues, providers);
        this.gf = this.snippet(providers, a.class, "hybridArraycopySnippet", new LocationIdentity[0]);
        map.put(o.class, new a());
    }

    @Snippet
    private static void hybridArraycopySnippet(Object object, int n2, Object object2, int n3, int n4, @Snippet.ConstantParameter JavaKind javaKind, @Snippet.ConstantParameter boolean bl2) {
        ReplacementsUtil.staticAssert((javaKind == JavaKind.Byte ? 1 : 0) != 0, (String)"only byte[] is supported");
        if (bl2) {
            a.callHybridArraycopy((ForeignCallDescriptor)gc, object, n2, object2, n3, n4);
        } else {
            a.callHybridArraycopy((ForeignCallDescriptor)gd, object, n2, object2, n3, n4);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doHybridByteArraycopy(Object object, int n2, Object object2, int n3, int n4) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        ArrayUtil.boundsCheckInSnippet((Object)object, (int)n2, (Object)object2, (int)n3, (int)n4);
        a.a(object, n2, object2, n3, n4);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doHybridByteArraycopyNonThrowing(Object object, int n2, Object object2, int n3, int n4) {
        assert (object != null && object2 != null) : "Expected fromArray and toArray to be non-null";
        assert (n4 >= 0) : "Expected length to be positive";
        assert (0 <= n2 && n2 <= ArrayLengthNode.arrayLength((Object)object) - n4) : "fromIndex is out of bounds";
        assert (0 <= n3 && n3 <= ArrayLengthNode.arrayLength((Object)object2) - n4) : "toIndex is out of bounds";
        a.a(object, n2, object2, n3, n4);
    }

    private static void a(Object object, int n2, Object object2, int n3, int n4) {
        int n5 = KnownIntrinsics.readHub((Object)object).getLayoutEncoding();
        UnsignedWord unsignedWord = LayoutEncoding.getArrayElementOffset((int)n5, (int)n2);
        int n6 = KnownIntrinsics.readHub((Object)object2).getLayoutEncoding();
        UnsignedWord unsignedWord2 = LayoutEncoding.getArrayElementOffset((int)n6, (int)n3);
        assert (object != object2) : "Expected fromArray and toArray to be different objects";
        assert (LayoutEncoding.getArrayIndexScale((int)n6) == a.getArrayIndexScale(JavaKind.Byte)) : "Expected a byte[]";
        assert (LayoutEncoding.getArrayIndexScale((int)n6) == LayoutEncoding.getArrayIndexScale((int)n5)) : "Expected fromArray and toArray to have the same array element size";
        JavaMemoryUtil.copyPrimitiveArrayForward((Object)object, (UnsignedWord)unsignedWord, (Object)object2, (UnsignedWord)unsignedWord2, (UnsignedWord)((UnsignedWord)WordFactory.signed((int)n4)));
    }

    @Fold
    protected static int getArrayIndexScale(JavaKind javaKind) {
        return ConfigurationValues.getObjectLayout().getArrayIndexScale(javaKind);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callHybridArraycopy(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, int var2, Object var3, int var4, int var5);

    final class a
    implements NodeLoweringProvider<o> {
        a() {
        }

        public void a(o o2, LoweringTool loweringTool) {
            SnippetTemplate.Arguments arguments = new SnippetTemplate.Arguments(a.this.gf, o2.graph().getGuardsStage(), loweringTool.getLoweringStage());
            arguments.add("fromArray", (Object)o2.getSource());
            arguments.add("fromIndex", (Object)o2.getSourcePosition());
            arguments.add("toArray", (Object)o2.getDestination());
            arguments.add("toIndex", (Object)o2.getDestinationPosition());
            arguments.add("length", (Object)o2.getLength());
            arguments.addConst("elementKind", (Object)o2.getElementKind());
            arguments.addConst("hasSideEffect", (Object)o2.hasSideEffect());
            a.this.template((CoreProviders)loweringTool, (ValueNode)o2, arguments).instantiate(loweringTool.getMetaAccess(), (FixedNode)o2, SnippetTemplate.DEFAULT_REPLACER, arguments);
        }

        public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
            this.a((o)node, loweringTool);
        }
    }
}

