/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.ap;
import com.oracle.svm.enterprise.gc.g1.bv;
import com.oracle.svm.enterprise.gc.g1.bw;
import com.oracle.svm.enterprise.gc.g1.nativelib.SharedGCStructs;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class G1StackWalker {
    private static final e nL = new e();
    private static final c nM = new c();
    private static final a nN = new a();
    public final CEntryPointLiteral<CFunctionPointer> nO = CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class});
    public final CEntryPointLiteral<CFunctionPointer> nP = CEntryPointLiteral.create(G1StackWalker.class, (String)"freeThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.StackFramesPerThread.class});
    public final CEntryPointLiteral<CFunctionPointer> nQ = Continuation.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchContinuationStackFrames", (Class[])new Class[]{PointerBase.class, Pointer.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nR = Continuation.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeContinuationStackFrames", (Class[])new Class[]{PointerBase.class, SharedGCStructs.StackFrames.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nS = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> nT = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.CodeInfosPerThread.class}) : null;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public G1StackWalker() {
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFramesPerThread fetchThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(nL);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.StackFramesPerThread stackFramesPerThread) {
        int n2 = 0;
        while ((long)n2 < stackFramesPerThread.count()) {
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFramesPerThread.threads().j(n2).di());
            ++n2;
        }
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFramesPerThread);
    }

    @Uninterruptible(reason="May be called by a non-Java thread (at or outside a safepoint).")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFrames fetchContinuationStackFrames(PointerBase pointerBase, Pointer pointer) {
        StoredContinuation storedContinuation = (StoredContinuation)pointer.toObject();
        ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)StackValue.get(ContinuationStackFrameCollectorData.class);
        c.a(continuationStackFrameCollectorData);
        StoredContinuationAccess.walkFrames((StoredContinuation)storedContinuation, (StoredContinuationAccess.ContinuationStackFrameVisitor)nM, (StoredContinuationAccess.ContinuationStackFrameVisitorData)continuationStackFrameCollectorData);
        return continuationStackFrameCollectorData.getStack();
    }

    @Uninterruptible(reason="May be called by a non-Java thread (at or outside a safepoint).")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeContinuationStackFrames(PointerBase pointerBase, SharedGCStructs.StackFrames stackFrames) {
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)stackFrames);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.CodeInfosPerThread fetchCodeInfos(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(nN);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeCodeInfos(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.CodeInfosPerThread codeInfosPerThread) {
        int n2 = 0;
        while ((long)n2 < codeInfosPerThread.count()) {
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)codeInfosPerThread.threads().g(n2).dh());
            ++n2;
        }
        ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)codeInfosPerThread);
    }

    @NeverInline(value="Stack walking.")
    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <T extends PointerBase, U extends PointerBase> T a(b<T, U> b2) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Doing a stack walk for every thread is only possible when we are at a safepoint.");
        b2.cN();
        b2.cO();
        JavaStackWalker.walkCurrentThread((Pointer)KnownIntrinsics.readCallerStackPointer(), b2, null);
        b2.cP();
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            if (isolateThread != CurrentIsolate.getCurrentThread()) {
                b2.cO();
                JavaStackWalker.walkThread((IsolateThread)isolateThread, b2, null);
                b2.cP();
            }
            isolateThread = VMThreads.nextThread((IsolateThread)isolateThread);
        }
        return b2.cS();
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V f(UnsignedWord unsignedWord) {
        PointerBase pointerBase = ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).malloc(unsignedWord);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"malloc returned null.");
        }
        return (V)pointerBase;
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V a(V v2, UnsignedWord unsignedWord) {
        PointerBase pointerBase = ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).realloc(v2, unsignedWord);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"realloc returned null.");
        }
        return (V)pointerBase;
    }

    private static class e
    extends b<SharedGCStructs.StackFramesPerThread, SharedGCStructs.StackFrames> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        e() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cN() {
            assert (((SharedGCStructs.StackFramesPerThread)this.nW).isNull() && this.nX == 0 && ((SharedGCStructs.StackFrames)this.nY).isNull() && this.nZ == 0);
            this.nX = 5;
            this.nW = G1StackWalker.f(this.cT());
            ((SharedGCStructs.StackFramesPerThread)this.nW).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cO() {
            assert (((SharedGCStructs.StackFrames)this.nY).isNull() && this.nZ == 0);
            this.nZ = 10;
            this.nY = G1StackWalker.f(this.cU());
            ((SharedGCStructs.StackFrames)this.nY).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cP() {
            long l2 = ((SharedGCStructs.StackFramesPerThread)this.nW).count();
            if (l2 == (long)this.nX) {
                this.nX *= 2;
                this.nW = G1StackWalker.a((SharedGCStructs.StackFramesPerThread)this.nW, this.cT());
            }
            ((SharedGCStructs.StackFramesPerThread)this.nW).threads().j(l2).a((SharedGCStructs.StackFrames)this.nY);
            ((SharedGCStructs.StackFramesPerThread)this.nW).setCount(l2 + 1L);
            this.nY = WordFactory.nullPointer();
            this.nZ = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object object) {
            if (deoptimizedFrame != null) {
                return true;
            }
            NonmovableArray nonmovableArray = CodeInfoAccess.getStackReferenceMapEncoding((CodeInfo)codeInfo);
            long l2 = CodeInfoAccess.lookupStackReferenceMapIndex((CodeInfo)codeInfo, (long)CodeInfoAccess.relativeIP((CodeInfo)codeInfo, (CodePointer)codePointer));
            this.a(pointer, (NonmovableArray<Byte>)nonmovableArray, l2);
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void a(Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2) {
            long l3 = ((SharedGCStructs.StackFrames)this.nY).count();
            if (l3 == (long)this.nZ) {
                this.nZ *= 2;
                this.nY = G1StackWalker.a((SharedGCStructs.StackFrames)this.nY, this.cU());
            }
            SharedGCStructs.StackFrame stackFrame = ((SharedGCStructs.StackFrames)this.nY).frames().i(l3);
            stackFrame.setStackPointer(pointer);
            stackFrame.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            stackFrame.setReferenceMapIndex(l2);
            ((SharedGCStructs.StackFrames)this.nY).setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cT() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.nX));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cU() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.nZ));
        }
    }

    private static abstract class b<T extends PointerBase, U extends PointerBase>
    extends ParameterizedStackFrameVisitor {
        protected static final int nU = 5;
        protected static final int nV = 10;
        protected T nW;
        protected int nX;
        protected U nY;
        protected int nZ;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        b() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cN();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cO();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void cP();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public T cS() {
            assert (this.nY.isNull());
            assert (this.nZ == 0);
            T t2 = this.nW;
            this.nW = WordFactory.nullPointer();
            this.nX = 0;
            return t2;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        protected final boolean unknownFrame(Pointer pointer, CodePointer codePointer, DeoptimizedFrame deoptimizedFrame, Object object) {
            throw JavaStackWalker.reportUnknownFrameEncountered((Pointer)pointer, (CodePointer)codePointer, (DeoptimizedFrame)deoptimizedFrame);
        }
    }

    @RawStructure
    private static interface ContinuationStackFrameCollectorData
    extends StoredContinuationAccess.ContinuationStackFrameVisitorData {
        @RawField
        public int getCapacity();

        @RawField
        public void setCapacity(int var1);

        @RawField
        public SharedGCStructs.StackFrames getStack();

        @RawField
        public void setStack(SharedGCStructs.StackFrames var1);
    }

    private static class c
    extends StoredContinuationAccess.ContinuationStackFrameVisitor {
        private static final int oa = 10;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        c() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public static void a(ContinuationStackFrameCollectorData continuationStackFrameCollectorData) {
            UnsignedWord unsignedWord = c.q(10);
            SharedGCStructs.StackFrames stackFrames = (SharedGCStructs.StackFrames)G1StackWalker.f(unsignedWord);
            stackFrames.setCount(0L);
            continuationStackFrameCollectorData.setStack(stackFrames);
            continuationStackFrameCollectorData.setCapacity(10);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void visitFrame(StoredContinuationAccess.ContinuationStackFrameVisitorData continuationStackFrameVisitorData, Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2, StoredContinuationAccess.ContinuationStackFrameVisitor continuationStackFrameVisitor) {
            Object object;
            ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)continuationStackFrameVisitorData;
            long l3 = continuationStackFrameCollectorData.getStack().count();
            if (l3 == (long)continuationStackFrameCollectorData.getCapacity()) {
                int n2 = continuationStackFrameCollectorData.getCapacity() * 2;
                object = G1StackWalker.a(continuationStackFrameCollectorData.getStack(), c.q(n2));
                continuationStackFrameCollectorData.setStack((SharedGCStructs.StackFrames)object);
                continuationStackFrameCollectorData.setCapacity(n2);
            }
            SharedGCStructs.StackFrames stackFrames = continuationStackFrameCollectorData.getStack();
            object = stackFrames.frames().i(l3);
            object.setStackPointer(pointer);
            object.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            object.setReferenceMapIndex(l2);
            stackFrames.setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only execute uninterruptible code.")
        private static UnsignedWord q(int n2) {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(n2));
        }
    }

    private static class a
    extends b<SharedGCStructs.CodeInfosPerThread, SharedGCStructs.CodeInfos> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        a() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cN() {
            assert (((SharedGCStructs.CodeInfosPerThread)this.nW).isNull() && this.nX == 0 && ((SharedGCStructs.CodeInfos)this.nY).isNull() && this.nZ == 0);
            this.nX = 5;
            this.nW = G1StackWalker.f(this.cQ());
            ((SharedGCStructs.CodeInfosPerThread)this.nW).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cO() {
            assert (((SharedGCStructs.CodeInfos)this.nY).isNull() && this.nZ == 0);
            this.nZ = 10;
            this.nY = G1StackWalker.f(this.cR());
            ((SharedGCStructs.CodeInfos)this.nY).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void cP() {
            long l2 = ((SharedGCStructs.CodeInfosPerThread)this.nW).count();
            if (l2 == (long)this.nX) {
                this.nX *= 2;
                this.nW = G1StackWalker.a((SharedGCStructs.CodeInfosPerThread)this.nW, this.cQ());
            }
            ((SharedGCStructs.CodeInfosPerThread)this.nW).threads().g(l2).a((SharedGCStructs.CodeInfos)this.nY);
            ((SharedGCStructs.CodeInfosPerThread)this.nW).setCount(l2 + 1L);
            this.nY = WordFactory.nullPointer();
            this.nZ = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame, Object object) {
            if (deoptimizedFrame == null && codeInfo.notEqual((ComparableWord)CodeInfoTable.getImageCodeInfo())) {
                this.d(codeInfo);
            }
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void d(CodeInfo codeInfo) {
            long l2 = ((SharedGCStructs.CodeInfos)this.nY).count();
            if (l2 == (long)this.nZ) {
                this.nZ *= 2;
                this.nY = G1StackWalker.a((SharedGCStructs.CodeInfos)this.nY, this.cR());
            }
            ((SharedGCStructs.CodeInfos)this.nY).codeInfos().addressOf(l2).write(codeInfo);
            ((SharedGCStructs.CodeInfos)this.nY).setCount(l2 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cQ() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.nX));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord cR() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.nZ));
        }
    }

    private static class f
    implements BooleanSupplier {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        f() {
        }

        @Override
        public boolean getAsBoolean() {
            return (Boolean)ap.UseG1GC.getValue() != false && Continuation.isSupported();
        }
    }

    private static class d
    implements CEntryPointOptions.Prologue {
        private d() {
        }

        @Uninterruptible(reason="prologue")
        public static void b(PointerBase pointerBase) {
            CEntryPointSnippets.setHeapBase((PointerBase)pointerBase);
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)((IsolateThread)WordFactory.nullPointer()));
        }
    }
}

