/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1.graal;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.enterprise.gc.g1.b;
import com.oracle.svm.enterprise.gc.g1.e;
import com.oracle.svm.enterprise.gc.g1.i;
import com.oracle.svm.enterprise.gc.g1.j;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class a
implements GCAllocationSupport {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oM = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewInstance", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oN = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewArray", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oO = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewStoredContinuation", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oP = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewPodInstance", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] oQ = new SnippetRuntime.SubstrateForeignCallDescriptor[]{oM, oN};
    public static final FastThreadLocalObject<Object> oR = FastThreadLocalFactory.createObject(Object.class, (String)"vmResult");
    public static final FastThreadLocalObject<Object> oS = FastThreadLocalFactory.createObject(Object.class, (String)"podReferenceMap");

    public static void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(oQ);
        if (Continuation.isSupported()) {
            substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{oO});
        }
        if (Pod.RuntimeSupport.isPresent()) {
            substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{oP});
        }
    }

    public ForeignCallDescriptor getNewInstanceStub() {
        return oM;
    }

    public ForeignCallDescriptor getNewArrayStub() {
        return oN;
    }

    public ForeignCallDescriptor getNewStoredContinuationStub() {
        return oO;
    }

    public ForeignCallDescriptor getNewPodInstanceStub() {
        return oP;
    }

    public boolean useTLAB() {
        return (Boolean)j.UseTLAB.getValue();
    }

    public boolean shouldAllocateInTLAB(UnsignedWord unsignedWord, boolean bl2) {
        return true;
    }

    public Word getTLABInfo() {
        return (Word)e.mu.getAddress();
    }

    public int tlabTopOffset() {
        return b.tlabTopOffset();
    }

    public int tlabEndOffset() {
        return b.tlabEndOffset();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewInstance(Word word) {
        DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
        a.a("allocateInstance", dynamicHub);
        Object object = a.b(dynamicHub);
        return a.n(object);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewArray(Word word, int n2) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (n2 < 0 ? 1 : 0) != 0)) {
            throw new NegativeArraySizeException();
        }
        DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
        a.a("allocateArray", dynamicHub);
        Object object = a.a(n2, dynamicHub);
        return a.n(object);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewStoredContinuation(Word word, int n2) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (n2 < 0 ? 1 : 0) != 0)) {
            throw new NegativeArraySizeException();
        }
        DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
        a.a("allocateStoredContinuation", dynamicHub);
        Object object = a.b(n2, dynamicHub);
        return a.n(object);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewPodInstance(Word word, int n2, byte[] byArray) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (n2 < 0 ? 1 : 0) != 0)) {
            throw new NegativeArraySizeException();
        }
        DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
        a.a("allocatePod", dynamicHub);
        Object object = a.a(n2, dynamicHub, byArray);
        return a.n(object);
    }

    @Uninterruptible(reason="Prevent stack overflow exceptions and recurring callback execution.", calleeMustBe=false)
    private static Object b(DynamicHub dynamicHub) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateInstance(Word.objectToUntrackedPointer((Object)dynamicHub));
        return a.cV();
    }

    @Uninterruptible(reason="Prevent stack overflow exceptions and recurring callback execution.", calleeMustBe=false)
    private static Object a(int n2, DynamicHub dynamicHub) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateArray(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        return a.cV();
    }

    @Uninterruptible(reason="Prevent stack overflow exceptions and recurring callback execution.", calleeMustBe=false)
    private static Object b(int n2, DynamicHub dynamicHub) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateStoredContinuation(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        return a.cV();
    }

    @Uninterruptible(reason="Prevent stack overflow exceptions and recurring callback execution.", calleeMustBe=false)
    private static Object a(int n2, DynamicHub dynamicHub, byte[] byArray) {
        oS.set((Object)byArray);
        com.oracle.svm.enterprise.gc.g1.nativelib.b.allocatePod(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        Object object = a.cV();
        oS.set(null);
        return object;
    }

    @Uninterruptible(reason="Prevent stack overflow exceptions and recurring callback execution.", callerMustBe=true)
    public static Object cV() {
        Object object = oR.get();
        oR.set(null);
        return object;
    }

    private static void a(String string, DynamicHub dynamicHub) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)e.get().isAllocationDisallowed())) {
            NoAllocationVerifier.exit((String)string, (String)DynamicHub.toClass((DynamicHub)dynamicHub).getName());
        }
    }

    private static Object n(Object object) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (object == null ? 1 : 0) != 0)) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
        return object;
    }
}

