/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.cai;

import com.oracle.graal.compiler.enterprise.EnterpriseHighTier;
import com.oracle.graal.compiler.enterprise.phases.CountedStripMiningPhase;
import com.oracle.graal.compiler.enterprise.phases.EnterpriseGVNPhase;
import com.oracle.graal.compiler.enterprise.phases.EnterprisePartialUnrollPhase;
import com.oracle.graal.compiler.enterprise.phases.LoopRotationPhase;
import com.oracle.graal.compiler.enterprise.phases.NonCountedStripMiningPhase;
import com.oracle.graal.compiler.enterprise.phases.writemotion.WriteMotionPhase;
import com.oracle.graal.duplication.phases.PullThroughPhiPhase;
import com.oracle.graal.duplication.phases.simulation.DuplicationPhase;
import com.oracle.graal.duplication.phases.simulation.e;
import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.vector.phases.LoopVectorizationPhase;
import com.oracle.graal.vector.phases.simd.SIMDVectorizationPhase;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.enterprise.core.graal.GuardHoistingLoopDuplicationPhase;
import com.oracle.svm.enterprise.hosted.cai.d;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.phases.BeforeHotCallerCompilationPhase;
import com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.SubstratePriorityInliningPhase;
import com.oracle.svm.enterprise.hosted.phases.priorityinline.h;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopFullUnrollPhase;
import org.graalvm.compiler.loop.phases.LoopPartialUnrollPhase;
import org.graalvm.compiler.loop.phases.LoopPeelingPhase;
import org.graalvm.compiler.loop.phases.LoopUnswitchingPhase;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.HighTierLoweringPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.nativeimage.ImageSingletons;

public final class a
extends com.oracle.svm.enterprise.hosted.code.a {
    private final com.oracle.svm.enterprise.hosted.pgo.d<a> pU;
    private final ConcurrentMap<HostedMethod, d.c> pV = new ConcurrentHashMap<HostedMethod, d.c>();
    private final PGOProfilesLookup pW;
    private final Map<HostedMethod, Set<CompileQueue.CompileReason>> pX = new ConcurrentHashMap<HostedMethod, Set<CompileQueue.CompileReason>>();
    private boolean pY;
    private Suites pZ;

    public a(DebugContext debugContext, FeatureHandler featureHandler, HostedUniverse hostedUniverse, RuntimeConfiguration runtimeConfiguration, Boolean bl2, SnippetReflectionProvider snippetReflectionProvider, ForkJoinPool forkJoinPool, PGOProfilesLookup pGOProfilesLookup) {
        super(debugContext, featureHandler, hostedUniverse, runtimeConfiguration, bl2, snippetReflectionProvider, forkJoinPool, pGOProfilesLookup);
        this.pW = pGOProfilesLookup;
        this.pU = new com.oracle.svm.enterprise.hosted.pgo.d<a>(pGOProfilesLookup, a::new);
        ImageSingletons.add(com.oracle.svm.enterprise.hosted.pgo.d.class, this.pU);
    }

    protected CompileQueue.CompileTask createCompileTask(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason) {
        return new CompileQueue.CompileTask(hostedMethod, compileReason){

            public void run(DebugContext debugContext) {
                if (this.reason instanceof b) {
                    a.b(this.method);
                }
                super.run(debugContext);
            }
        };
    }

    protected void compileAll() throws InterruptedException {
        this.du();
        this.runOnExecutor(this::ds);
        this.dw();
        this.runOnExecutor(this::dt);
        this.dr();
        super.compileAll();
    }

    private void dr() {
        if (!com.oracle.svm.enterprise.hosted.cai.b.CAIPrintPrefixTree.hasBeenSet()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.pU.b((List<Pair<d.c, Integer>> list) -> {
            Pair pair = (Pair)list.get(list.size() - 1);
            long l2 = ((d.c)pair.getLeft()).eY();
            if (l2 <= 0L) {
                return;
            }
            for (Pair pair2 : list) {
                Integer n2 = (Integer)pair2.getRight();
                a a2 = (a)((d.c)pair2.getLeft()).eX();
                String string = a2.dx() == null ? ((d.c)pair2.getLeft()).fa().format("%H.%n") : a2.dx().format("%H.%n");
                stringBuilder.append(string).append(":").append(n2);
                if (a2.dy() == a.a.qf) {
                    stringBuilder.append("_[i]");
                }
                if (a2.dy() == a.a.qg) {
                    stringBuilder.append("_[k]");
                }
                stringBuilder.append(";");
            }
            stringBuilder.append(" ").append(l2).append(System.lineSeparator());
        });
        Path path = Paths.get((String)com.oracle.svm.enterprise.hosted.cai.b.CAIPrintPrefixTreePath.getValue(), new String[0]).toAbsolutePath();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(path.toFile()));){
            bufferedWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void a(HostedMethod hostedMethod2, CompileQueue.CompileReason compileReason) {
        this.pX.computeIfAbsent(hostedMethod2, hostedMethod -> new HashSet()).add(compileReason);
    }

    protected void ensureCompiled(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason) {
        if (this.pY) {
            this.b(hostedMethod, compileReason);
        } else {
            super.ensureCompiled(hostedMethod, compileReason);
        }
    }

    private void b(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason) {
        if (compileReason instanceof b) {
            super.ensureCompiled(hostedMethod, compileReason);
        } else {
            this.a(hostedMethod, compileReason);
        }
    }

    public static void b(HostedMethod hostedMethod) {
        OptionValues optionValues = hostedMethod.compilationInfo.getCompileOptions();
        UnmodifiableEconomicMap unmodifiableEconomicMap = optionValues.getMap();
        EconomicMap economicMap = OptionValues.newOptionMap();
        economicMap.putAll(unmodifiableEconomicMap);
        if (((Boolean)com.oracle.svm.enterprise.hosted.cai.b.qk.getValue(optionValues)).booleanValue()) {
            economicMap.put((Object)PriorityInliningPhase.b.zl, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationBaseTargetSpending.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yS, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationCompilerNodePenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yR, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationCutoffCodeSizePenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zc, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationExpansionInertiaBaseValue.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yY, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationLargeChildrenCountPenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zm, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationMaxPolymorphicDispatches.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zn, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationMinPolymorphicDispatchProbability.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zo, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationRelativeBenefitInliningCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.yV, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationSmallRootIrPenaltyCoefficient.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zf, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationTypicalGraphSize.getValue());
            economicMap.put((Object)PriorityInliningPhase.b.zg, com.oracle.svm.enterprise.hosted.cai.b.HotCompilationTypicalGraphSizeInvokeBonus.getValue());
            economicMap.put((Object)EnterpriseHighTier.a.af, (Object)4);
            economicMap.put((Object)e.kC, (Object)2.0);
            economicMap.put((Object)PullThroughPhiPhase.b.ju, (Object)2.0);
            economicMap.put((Object)GraalOptions.LoopMaxUnswitch, (Object)4);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchMaxIncrease, (Object)4000);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchTrivial, (Object)40);
            economicMap.put((Object)DefaultLoopPolicies.Options.LoopUnswitchFrequencyBoost, (Object)40.0);
            economicMap.put((Object)DefaultLoopPolicies.Options.DefaultLoopFrequency, (Object)1000.0);
            economicMap.put((Object)DefaultLoopPolicies.Options.DefaultUnswitchFactor, (Object)0.9);
        }
        hostedMethod.compilationInfo.setCompileOptions(new OptionValues((UnmodifiableEconomicMap)economicMap));
    }

    protected void ensureCalleesCompiled(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult) {
        if (compileReason instanceof b) {
            this.a(hostedMethod, compileReason, compilationResult);
        } else {
            super.ensureCalleesCompiled(hostedMethod, compileReason, compilationResult);
        }
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult) {
        d d2 = d.f(hostedMethod);
        this.a(hostedMethod, compileReason, compilationResult, d2);
        this.ensureCompiledForMethodPointerConstants(hostedMethod, compileReason, compilationResult);
        d2.dA();
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, CompilationResult compilationResult, d d2) {
        a.a(compilationResult, (Call call) -> {
            BytecodePosition bytecodePosition = call.debugInfo != null ? call.debugInfo.getBytecodePosition() : null;
            HostedMethod hostedMethod2 = (HostedMethod)call.target;
            if (call.direct || this.isDynamicallyResolvedCall(compilationResult, (Call)call)) {
                this.a(hostedMethod, compileReason, bytecodePosition, hostedMethod2, d2);
            } else if (hostedMethod2 != null && hostedMethod2.getImplementations() != null) {
                d2.c(bytecodePosition, hostedMethod2);
                for (HostedMethod hostedMethod3 : hostedMethod2.getImplementations()) {
                    this.a(hostedMethod3, (CompileQueue.CompileReason)new CompileQueue.VirtualCallReason(hostedMethod, hostedMethod2, compileReason));
                }
            }
        });
    }

    private static void a(CompilationResult compilationResult, Consumer<Call> consumer) {
        for (Infopoint infopoint : compilationResult.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            consumer.accept(call);
        }
    }

    private void a(HostedMethod hostedMethod, CompileQueue.CompileReason compileReason, BytecodePosition bytecodePosition, HostedMethod hostedMethod2, d d2) {
        d.c c2 = (d.c)this.pV.get(hostedMethod);
        d.c c3 = c2.b(bytecodePosition, (ResolvedJavaMethod)hostedMethod2);
        if (c3 != null && a.a(hostedMethod2, c3) && c3.eV()) {
            d2.a(bytecodePosition, hostedMethod2);
            a.a(c3, hostedMethod2, a.a.qd);
            this.pV.put(hostedMethod2, c3);
            this.ensureCompiled(hostedMethod2, new b());
        } else {
            this.a(hostedMethod2, (CompileQueue.CompileReason)new CompileQueue.DirectCallReason(hostedMethod, compileReason));
            d2.b(bytecodePosition, hostedMethod2);
            if (c3 != null) {
                a.a(c3, hostedMethod2, a.a.qe);
            }
        }
    }

    private static void a(d.c c2, HostedMethod hostedMethod, a.a a2) {
        ((a)c2.eX()).e(hostedMethod);
        ((a)c2.eX()).b(a2);
        if (a2 == a.a.qe || a.a(c2)) {
            for (List<d.c> list : c2.eZ().values()) {
                for (d.c c3 : list) {
                    a.b(c3);
                }
            }
        }
    }

    private static boolean a(d.c c2) {
        if (!c2.fb()) {
            return false;
        }
        HostedMethod hostedMethod = ((a)c2.eX()).qb;
        d.c c3 = c2;
        while (c3.eU() != null) {
            c3 = (d.c)c3.eU();
            HostedMethod hostedMethod2 = ((a)c3.eX()).qb;
            if (hostedMethod2 == null || !hostedMethod2.equals(hostedMethod)) continue;
            return true;
        }
        return false;
    }

    private static void b(d.c c2) {
        ((a)c2.eX()).b(a.a.qg);
        for (List<d.c> list : c2.eZ().values()) {
            for (d.c c3 : list) {
                a.b(c3);
            }
        }
    }

    private static boolean a(HostedMethod hostedMethod, d.c c2) {
        boolean bl2 = hostedMethod.wrapped.equals((Object)c2.fa());
        if (!bl2) {
            DebugContext.forCurrentThread().log("[CAICompileQueue] Callee context does not match callee.");
        }
        return bl2;
    }

    private void ds() {
        this.pU.eQ().stream().map(arg_0 -> ((HostedUniverse)this.universe).lookup(arg_0)).forEach(this::c);
    }

    private void dt() {
        this.pX.forEach((hostedMethod, set) -> {
            for (CompileQueue.CompileReason compileReason : set) {
                super.ensureCompiled(hostedMethod, compileReason);
            }
        });
        this.pX.clear();
    }

    private void du() {
        this.pY = true;
        this.dv();
    }

    private void dv() {
        PhaseSuite phaseSuite = this.getRegularSuites().getHighTier();
        ListIterator listIterator = phaseSuite.findPhase(SubstratePriorityInliningPhase.class);
        SubstratePriorityInliningPhase substratePriorityInliningPhase = (SubstratePriorityInliningPhase)((Object)listIterator.previous());
        SubstratePriorityInliningPhase substratePriorityInliningPhase2 = new SubstratePriorityInliningPhase(substratePriorityInliningPhase, new h(this.universe, this.pV::get), this.pW);
        listIterator.remove();
        listIterator.add(substratePriorityInliningPhase2);
        BeforeHotCallerCompilationPhase beforeHotCallerCompilationPhase = new BeforeHotCallerCompilationPhase(this.universe, this.pV::get, this.pW);
        phaseSuite.prependPhase((BasePhase)beforeHotCallerCompilationPhase);
        if (!((Boolean)com.oracle.svm.enterprise.core.graal.pltgot.c.EnablePLTGOT.getValue()).booleanValue()) {
            HotMethodDuplicationPhase hotMethodDuplicationPhase = new HotMethodDuplicationPhase(this.pV::get);
            PhaseSuite phaseSuite2 = this.getRegularSuites().getLowTier();
            phaseSuite2.appendPhase(hotMethodDuplicationPhase);
        } else {
            HotMethodDuplicationPhase hotMethodDuplicationPhase = new HotMethodDuplicationPhase(this.pV::get);
            ListIterator listIterator2 = phaseSuite.findPhase(HighTierLoweringPhase.class);
            phaseSuite.insertAtIndex(listIterator2.previousIndex(), hotMethodDuplicationPhase);
        }
    }

    private void dw() {
        this.pY = false;
        this.createSuites();
        this.pZ = this.getRegularSuites().copy();
        PhaseSuite phaseSuite = this.pZ.getHighTier();
        phaseSuite.removeSubTypePhases(SubstratePriorityInliningPhase.class);
        phaseSuite.removeSubTypePhases(PartialEscapePhase.class);
        phaseSuite.removeSubTypePhases(DuplicationPhase.class);
        phaseSuite.removeSubTypePhases(EnterpriseGVNPhase.class);
        phaseSuite.removeSubTypePhases(PullThroughPhiPhase.class);
        phaseSuite.removeSubTypePhases(EnterpriseGVNPhase.class);
        phaseSuite.removeSubTypePhases(LoopPeelingPhase.class);
        phaseSuite.removeSubTypePhases(LoopUnswitchingPhase.class);
        phaseSuite.removeSubTypePhases(LoopFullUnrollPhase.class);
        phaseSuite.removeSubTypePhases(EnterprisePartialUnrollPhase.class);
        PhaseSuite phaseSuite2 = this.pZ.getMidTier();
        phaseSuite2.removeSubTypePhases(LoopRotationPhase.class);
        phaseSuite2.removeSubTypePhases(LoopPartialUnrollPhase.class);
        phaseSuite2.removeSubTypePhases(NonCountedStripMiningPhase.class);
        phaseSuite2.removeSubTypePhases(CountedStripMiningPhase.class);
        phaseSuite2.removeSubTypePhases(LoopPeelingPhase.class);
        phaseSuite2.removeSubTypePhases(EnterpriseGVNPhase.class);
        phaseSuite2.removeSubTypePhases(LoopUnswitchingPhase.class);
        phaseSuite2.removeSubTypePhases(EnterprisePartialUnrollPhase.class);
        phaseSuite2.removeSubTypePhases(LoopFullUnrollPhase.class);
        phaseSuite2.removeSubTypePhases(PullThroughPhiPhase.class);
        phaseSuite2.removeSubTypePhases(GuardHoistingLoopDuplicationPhase.class);
        phaseSuite2.removeSubTypePhases(WriteMotionPhase.class);
        phaseSuite2.removeSubTypePhases(SIMDVectorizationPhase.class);
        phaseSuite2.removeSubTypePhases(LoopVectorizationPhase.class);
    }

    protected Suites createSuitesForRegularCompile(StructuredGraph structuredGraph, Suites suites) {
        long l2;
        if (PGOFeature.isPGOEnabled() && !((Boolean)com.oracle.svm.enterprise.hosted.cai.b.CAIAggressiveColdCodeOptimizations.getValue(structuredGraph.getOptions())).booleanValue() && this.pZ != null && structuredGraph.method() != null && !this.pU.v((HostedMethod)structuredGraph.method()) && (l2 = this.b(structuredGraph).longValue()) <= (long)((Integer)com.oracle.svm.enterprise.hosted.cai.b.CAIColdCodeMaxInvocations.getValue(structuredGraph.getOptions())).intValue()) {
            return this.pZ;
        }
        return super.createSuitesForRegularCompile(structuredGraph, suites);
    }

    private Long b(StructuredGraph structuredGraph) {
        return this.pW.getCallCountProfile((HostedMethod)structuredGraph.method()).map(a2 -> a2.fj().isProfiled() ? (Long)a2.fk() : 0L).orElse(0L);
    }

    public void c(HostedMethod hostedMethod) {
        d.c c2 = this.pU.u(hostedMethod);
        a.a(c2, hostedMethod, a.a.qd);
        d.c c3 = this.pV.putIfAbsent(hostedMethod, c2);
        assert (c3 == null);
        this.ensureCompiled(hostedMethod, new b());
    }

    protected void customizeGraph(StructuredGraph structuredGraph, CompileQueue.CompileReason compileReason) {
        structuredGraph.setGlobalProfileProvider((StructuredGraph.GlobalProfileProvider)new c(structuredGraph, compileReason));
    }

    public static class b
    extends CompileQueue.CompileReason {
        public b() {
            super(null);
        }

        public String toString() {
            return "hot caller";
        }
    }

    public static final class com.oracle.svm.enterprise.hosted.cai.a$a {
        private HostedMethod qb;
        private a qc = a.qf;

        public synchronized HostedMethod dx() {
            return this.qb;
        }

        public synchronized void e(HostedMethod hostedMethod) {
            this.qb = hostedMethod;
        }

        public a dy() {
            return this.qc;
        }

        public void b(a a2) {
            this.qc = a2;
        }

        public static final class a
        extends Enum<a> {
            public static final /* enum */ a qd = new a();
            public static final /* enum */ a qe = new a();
            public static final /* enum */ a qf = new a();
            public static final /* enum */ a qg = new a();
            private static final /* synthetic */ a[] $VALUES;

            public static a[] values() {
                return (a[])$VALUES.clone();
            }

            public static a F(String string) {
                return Enum.valueOf(a.class, string);
            }

            private static /* synthetic */ a[] dz() {
                return new a[]{qd, qe, qf, qg};
            }

            static {
                $VALUES = a.dz();
            }
        }
    }

    final class c
    implements StructuredGraph.GlobalProfileProvider {
        private final StructuredGraph qh;
        private final CompileQueue.CompileReason qi;

        c(StructuredGraph structuredGraph, CompileQueue.CompileReason compileReason) {
            this.qh = structuredGraph;
            this.qi = compileReason;
        }

        public double getGlobalSelfTimePercent() {
            ResolvedJavaMethod resolvedJavaMethod = this.qh.method();
            assert (resolvedJavaMethod instanceof HostedMethod);
            d.c c2 = (d.c)a.this.pV.get(resolvedJavaMethod);
            if (c2 == null) {
                return 0.0;
            }
            long l2 = c2.fd();
            for (Invoke invoke : this.qh.getInvokes()) {
                assert (invoke.getTargetMethod() instanceof HostedMethod);
                HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
                d.c c3 = c2.b((BytecodePosition)invoke.asNode().getNodeSourcePosition(), (ResolvedJavaMethod)hostedMethod);
                HostedMethod hostedMethod2 = (HostedMethod)resolvedJavaMethod;
                if (c3 == null || Objects.equals(hostedMethod.wrapped, hostedMethod2.wrapped)) continue;
                l2 -= c3.fd();
            }
            return Math.max((double)l2, 0.0) / (double)a.this.pU.eO();
        }

        public boolean hotCaller() {
            return this.qi instanceof b;
        }
    }
}

