/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features.provider;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.OrtSession;
import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.provider.d;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.json.JSONParser;
import org.graalvm.util.json.JSONParserException;

@AutomaticallyRegisteredFeature
public class a
implements InternalFeature {
    private Field sg;
    private Field sh;
    private Properties si;
    private static final boolean sj;

    public static boolean el() {
        return Stream.of(Platform.LINUX_AMD64.class, Platform.LINUX_AARCH64.class, Platform.WINDOWS_AMD64.class).anyMatch(Platform::includedIn) || Stream.of(Platform.DARWIN_AMD64.class, Platform.DARWIN_AARCH64.class).anyMatch(Platform::includedIn) && a.a("macOS", 10, 15);
    }

    private static boolean a(String string, int n2, int n3) {
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.version");
        String[] stringArray = string3.split("\\.");
        int n4 = Integer.parseInt(stringArray[0]);
        int n5 = Integer.parseInt(stringArray[1]);
        return string2.replaceAll("\\s", "").toLowerCase().contains(string.toLowerCase()) && (n4 > n2 || n4 == n2 && n5 >= n3);
    }

    private static boolean em() {
        return (Boolean)a.MLProfileInference.getValue() != false && SubstrateOptions.optimizationLevel().isOneOf(new SubstrateOptions.OptimizationLevel[]{SubstrateOptions.OptimizationLevel.O2, SubstrateOptions.OptimizationLevel.O3});
    }

    public static boolean en() {
        return ((Boolean)a.MLGraphFeaturesExtraction.getValue() != false || a.em()) && a.el();
    }

    public static boolean eo() {
        return (Boolean)a.MLGraphFeaturesExtraction.getValue() != false && a.el();
    }

    public static boolean ep() {
        return a.em() && a.el();
    }

    public static boolean eq() {
        return ImageSingletons.contains(com.oracle.svm.enterprise.hosted.ml.models.a.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (a.ep() && !sj) {
            throw UserError.abort((String)("Machine learning based PGO profile inference is enabled but the required java.logging module is unavailable. PGO profile inference can be disabled with " + SubstrateOptionsParser.commandArgument(a.MLProfileInference, (String)"-") + " or by using " + SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)"1")), (Object[])new Object[0]);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        if (a.ep()) {
            try {
                Class clazz = ReflectionUtil.lookupClass((boolean)false, (String)"java.util.logging.LogManager");
                this.sg = ReflectionUtil.lookupField((Class)clazz, (String)"manager");
                this.sh = ReflectionUtil.lookupField((Class)clazz, (String)"props");
                this.si = (Properties)this.sh.get(this.sg.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Can not access the java log manager.\n");
            }
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        if (a.en()) {
            ImageSingletons.add(d.class, (Object)((Object)new d()));
        }
        if (a.ep()) {
            Path path = BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference_model");
            try {
                Path path2 = a.b(path, "dataset.config");
                Path path3 = a.b(path, "preprocessing.onnx");
                Path path4 = a.b(path, "model.onnx");
                a.a(path2, path3, path4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                a.a(fileNotFoundException, "Invalid Configuration File", true);
            }
            catch (IOException iOException) {
                a.a(iOException, "Invalid Inference Configuration File IO", true);
            }
            catch (JSONParserException jSONParserException) {
                a.a(jSONParserException, "Invalid JSON Configuration", true);
            }
            catch (OrtException ortException) {
                a.a(ortException, "ONNX Inference Error", true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                a.a(unsatisfiedLinkError, "Missing Inference Library", true);
            }
            catch (Exception exception) {
                a.a(exception, "General Inference Exception", true);
            }
            try {
                this.sh.set(this.sg.get(null), this.si);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Can not access the java log manager.\n");
            }
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        if (a.eq()) {
            try {
                ((com.oracle.svm.enterprise.hosted.ml.models.a)((Object)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.models.a.class))).q();
            }
            catch (Exception exception) {
                a.a(exception, "Can not close the ONNX ML model inference session", true);
            }
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess afterHeapLayoutAccess) {
        if (a.en()) {
            ((d)((Object)ImageSingletons.lookup(d.class))).v();
        }
    }

    private static Path b(Path path, String string) throws IOException {
        Path path2 = Path.of(String.valueOf(path), string);
        if (!Files.exists(path2, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Profile inference ML model configuration file %s not found. Check if the file is at the specified path.", path2));
        }
        if (!Files.isReadable(path2)) {
            throw new IOException(String.format("Profile inference ML model configuration file %s cannot be read. Check if you have read permissions for the file.", path2));
        }
        return path2;
    }

    private static void a(Path path, Path path2, Path path3) throws JSONParserException, IOException, OrtException, UnsatisfiedLinkError {
        EconomicMap<String, List<String>> economicMap = a.b(path);
        com.oracle.graal.compiler.enterprise.ml.features.preprocessing.a a2 = a.c(path2);
        com.oracle.svm.enterprise.hosted.ml.models.a a3 = a.a(path3, economicMap, a2);
        ImageSingletons.add(com.oracle.svm.enterprise.hosted.ml.models.a.class, (Object)((Object)a3));
    }

    private static EconomicMap<String, List<String>> b(Path path) throws JSONParserException, IOException {
        FileReader fileReader = new FileReader(path.toString());
        JSONParser jSONParser = new JSONParser((Reader)fileReader);
        Object object = jSONParser.parse();
        if (!(object instanceof EconomicMap)) {
            throw new JSONParserException("Invalid ML profile inference dataset configuration json file: " + String.valueOf(path));
        }
        EconomicMap economicMap = (EconomicMap)object;
        assert (economicMap.containsKey((Object)"encoders"));
        if (economicMap.get((Object)"encoders") instanceof EconomicMap) {
            return (EconomicMap)economicMap.get((Object)"encoders");
        }
        throw new JSONParserException("Invalid ML profile inference dataset encoders: " + String.valueOf(economicMap.get((Object)"encoders")));
    }

    private static com.oracle.graal.compiler.enterprise.ml.features.preprocessing.a c(Path path) throws UnsatisfiedLinkError, OrtException {
        OrtEnvironment ortEnvironment = OrtEnvironment.getEnvironment();
        OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
        sessionOptions.setOptimizationLevel(OrtSession.SessionOptions.OptLevel.BASIC_OPT);
        sessionOptions.setSessionLogLevel(OrtLoggingLevel.ORT_LOGGING_LEVEL_FATAL);
        sessionOptions.setInterOpNumThreads(1);
        sessionOptions.setIntraOpNumThreads(1);
        OrtSession ortSession = ortEnvironment.createSession(String.valueOf(path), sessionOptions);
        return new com.oracle.svm.enterprise.hosted.ml.features.preprocessing.a(ortEnvironment, ortSession);
    }

    private static com.oracle.svm.enterprise.hosted.ml.models.a a(Path path, EconomicMap<String, List<String>> economicMap, com.oracle.graal.compiler.enterprise.ml.features.preprocessing.a a2) throws UnsatisfiedLinkError, OrtException {
        OrtEnvironment ortEnvironment = OrtEnvironment.getEnvironment();
        OrtSession.SessionOptions sessionOptions = new OrtSession.SessionOptions();
        sessionOptions.setOptimizationLevel(OrtSession.SessionOptions.OptLevel.BASIC_OPT);
        sessionOptions.setSessionLogLevel(OrtLoggingLevel.ORT_LOGGING_LEVEL_FATAL);
        sessionOptions.setInterOpNumThreads(1);
        sessionOptions.setIntraOpNumThreads(1);
        OrtSession ortSession = ortEnvironment.createSession(String.valueOf(path), sessionOptions);
        return new com.oracle.svm.enterprise.hosted.ml.models.a(economicMap, a2, ortEnvironment, ortSession);
    }

    public static void a(Throwable throwable, String string, boolean bl2) {
        String string2 = "ML Profile Inference - " + string + ": " + String.valueOf(throwable);
        if (Assertions.assertionsEnabled()) {
            throw VMError.shouldNotReachHere((String)string2);
        }
        if (bl2) {
            LogUtils.warning((String)string2);
        }
    }

    static {
        Optional<Module> optional = ModuleLayer.boot().findModule("java.logging");
        if (optional.isPresent()) {
            a.class.getModule().addReads(optional.get());
        }
        sj = optional.isPresent();
    }

    public static class a {
        public static final HostedOptionKey<Boolean> MLProfileInference = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> MLGraphFeaturesExtraction = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> ClampMLInferredProfiles = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> MLProfileInferenceGuards = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Double> GuardMinLoopProbability = new HostedOptionKey((Object)0.2);
        public static final HostedOptionKey<Double> GuardMaxCondExitProbability = new HostedOptionKey((Object)0.8);
        public static final HostedOptionKey<Double> GuardMinCondEstimatedAssembly = new HostedOptionKey((Object)50.0);
    }
}

