/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.features;

import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.ap;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.c;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.pgo.profiles.b;
import com.oracle.svm.hosted.FeatureImpl;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class PGOFeature
implements InternalFeature {
    private static final long DEFAULT_PROFILES_NORMALIZATION_VALUE = 1000000000000000L;
    private static final long DEFAULT_CACHED_PROFILES_NORMALIZATION_VALUE = 100000000000000L;
    private static final String PGO_OPTIMIZED_QUALIFIER = "PGO optimized";

    public static boolean isPGOEnabled() {
        boolean bl2 = a.PGOEnabled.hasBeenSet();
        if (bl2 && SubstrateOptions.Optimize.hasBeenSet() && !SubstrateOptions.isMaximumOptimizationLevel()) {
            UserError.abort((String)"Optimization level hast been set to %s, optimization levels must not be set by users when using %s, the VM will configure the best optimizations for PGO.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)((String)SubstrateOptions.Optimize.getValue())), SubstrateOptionsParser.commandArgument(a.PGOEnabled, (String)((LocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).toString())});
        }
        return bl2 || a.AdoptedPGOEnabled.hasBeenSet();
    }

    public static boolean isPGOEnabled(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
        return unmodifiableEconomicMap.containsKey(a.PGOEnabled) || unmodifiableEconomicMap.containsKey(a.AdoptedPGOEnabled);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return PGOFeature.isPGOEnabled();
    }

    public static List<Path> getProfileFiles() {
        if (!a.PGOEnabled.hasBeenSet()) {
            return null;
        }
        List<Path> list = ((LocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).values();
        if (list.isEmpty()) {
            list = Collections.singletonList(Path.of("default.iprof", new String[0]));
        }
        return list;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        AnalysisUniverse analysisUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess).getUniverse();
        List<AnalysisType> list = analysisUniverse.getTypes().stream().filter(c::d).toList();
        Map<String, AnalysisType> map = list.stream().collect(Collectors.toMap(JavaType::toClassName, analysisType -> analysisType));
        Map<String, AnalysisMethod> map2 = analysisUniverse.getMethods().stream().collect(Collectors.toMap(analysisMethod -> Integer.toString(analysisMethod.getId()), analysisMethod -> analysisMethod));
        PGOFeature.loadProfiles(map, map2);
    }

    private static void loadProfiles(Map<String, AnalysisType> map, Map<String, AnalysisMethod> map2) {
        List<Path> list;
        b b2 = null;
        com.oracle.svm.enterprise.hosted.pgo.loaders.a a2 = new com.oracle.svm.enterprise.hosted.pgo.loaders.a(map, map2);
        if (a.PGOEnabled.hasBeenSet()) {
            list = ((LocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).values();
            if (list.isEmpty()) {
                list = Collections.singletonList(Path.of("default.iprof", new String[0]));
            }
            b2 = (b)a2.loadProfile(list, (Long)a.PGOProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.PROFILED);
        }
        list = null;
        if (a.AdoptedPGOEnabled.hasBeenSet()) {
            List list2 = ((LocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).values();
            assert (list2.size() > 0);
            list = (b)a2.loadProfile(list2, (Long)a.PGOAdoptedProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.ADOPTED);
        }
        assert (b2 != null || list != null);
        ImageSingletons.add(PGOProfilesLookup.class, (Object)new com.oracle.svm.enterprise.hosted.pgo.profiles.a(b2, (b)((Object)list)));
    }

    public static class a {
        @APIOption(name={"pgo"}, defaultValue={"default.iprof"})
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> PGOEnabled = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public void update(EconomicMap<OptionKey<?>, Object> economicMap, Object object) {
                super.update(economicMap, object);
                SubstrateOptions.Optimize.update(economicMap, (Object)String.valueOf(SubstrateOptions.OptimizationLevel.O3.getOptionSwitch()));
                ap.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                PGOContextSensitivityEnabled.update(economicMap, (Object)true);
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)true);
                a.a.MLProfileInference.update(economicMap, (Object)false);
                CompilerConfigurationFactory.setNativeImageLocationQualifier((String)PGOFeature.PGO_OPTIMIZED_QUALIFIER);
            }
        };
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> AdoptedPGOEnabled = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public LocatableMultiOptionValue.Paths e(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (LocatableMultiOptionValue.Paths)unmodifiableEconomicMap.get((Object)this);
                }
                Path path = BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("adopted_profiles").resolve("jdk_profile.iprof");
                if (path.toFile().exists()) {
                    return LocatableMultiOptionValue.Paths.buildWithDefaults((Path[])new Path[]{path});
                }
                return LocatableMultiOptionValue.Paths.buildWithCommaDelimiter();
            }

            public LocatableMultiOptionValue.Paths c(OptionValues optionValues) {
                return this.e(optionValues.getMap());
            }

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, LocatableMultiOptionValue.Paths paths, LocatableMultiOptionValue.Paths paths2) {
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)false);
                ap.AOTPriorityInline.update(economicMap, (Object)false);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (LocatableMultiOptionValue.Paths)object, (LocatableMultiOptionValue.Paths)object2);
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.e(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.c(optionValues);
            }
        };
        public static final HostedOptionKey<Boolean> PGOContextSensitivityEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    PriorityInliningPhase.b.zs.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        static final HostedOptionKey<Long> PGOProfilesNormalizationValue = new HostedOptionKey((Object)1000000000000000L);
        static final HostedOptionKey<Long> PGOAdoptedProfilesNormalizationValue = new HostedOptionKey((Object)100000000000000L);
        public static final HostedOptionKey<Boolean> PGOEnableProfileNormalization = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOPrintDroppedCallingContexts = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOPrintUnmatchedPercentage = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOIgnoreVersionCheck = new HostedOptionKey((Object)false);
    }
}

