/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.phases.PartialEscapeSelectiveInliningPhase;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.spi.NodeWithIdentity;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractLocalNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeBlockState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeClosure;

public class i
extends PartialEscapeClosure<PartialEscapeBlockState.Final> {
    private final CoreProviders uY;
    private final PartialEscapeSelectiveInliningPhase.c uZ;

    private static b a(DebugContext debugContext, SubstrateMethodCallTargetNode substrateMethodCallTargetNode, VirtualizerTool virtualizerTool, MetaAccessProvider metaAccessProvider) {
        if (substrateMethodCallTargetNode.invokeKind().isDirect()) {
            return new b(null, (HostedMethod)substrateMethodCallTargetNode.targetMethod());
        }
        JavaMethodProfile javaMethodProfile = substrateMethodCallTargetNode.getMethodProfile();
        if (javaMethodProfile == null) {
            return null;
        }
        VirtualObjectNode virtualObjectNode = PartialEscapeSelectiveInliningPhase.a((ValueNode)substrateMethodCallTargetNode.arguments().first(), virtualizerTool);
        if (virtualObjectNode == null) {
            return null;
        }
        ResolvedJavaType resolvedJavaType = virtualObjectNode.stamp(NodeView.DEFAULT).javaType(metaAccessProvider);
        if (debugContext.isLogEnabled(2)) {
            debugContext.log(2, ">> getSingleCallee: Use virtualThisType: %s", (Object)resolvedJavaType.toJavaName());
        }
        boolean bl2 = true;
        ResolvedJavaMethod resolvedJavaMethod = null;
        for (JavaMethodProfile.ProfiledMethod profiledMethod : javaMethodProfile.getMethods()) {
            ResolvedJavaMethod resolvedJavaMethod2 = profiledMethod.getMethod();
            ResolvedJavaType resolvedJavaType2 = resolvedJavaMethod2.getDeclaringClass();
            if (resolvedJavaType2.equals((Object)resolvedJavaType)) {
                if (debugContext.isLogEnabled(2)) {
                    debugContext.log(2, ">> getSingleCallee: equal-class method: %s", (Object)PartialEscapeSelectiveInliningPhase.e(resolvedJavaMethod2));
                }
                return new b(resolvedJavaType, (HostedMethod)resolvedJavaMethod2);
            }
            if (!resolvedJavaType2.isAssignableFrom(resolvedJavaType)) continue;
            if (resolvedJavaMethod != null) {
                bl2 = false;
                break;
            }
            resolvedJavaMethod = resolvedJavaMethod2;
        }
        if (resolvedJavaMethod != null && bl2) {
            if (debugContext.isLogEnabled(2)) {
                debugContext.log(2, ">> getSingleCallee: single assignable method: %s", (Object)PartialEscapeSelectiveInliningPhase.e(resolvedJavaMethod));
            }
            return new b(resolvedJavaType, (HostedMethod)resolvedJavaMethod);
        }
        return null;
    }

    i(StructuredGraph.ScheduleResult scheduleResult, CoreProviders coreProviders, PartialEscapeSelectiveInliningPhase.c c2) {
        super(scheduleResult, coreProviders);
        this.uY = coreProviders;
        this.uZ = c2;
    }

    private PartialEscapeSelectiveInliningPhase.a fm() {
        return this.uZ.fu();
    }

    protected boolean requiresProcessing(Node node) {
        return node instanceof SubstrateMethodCallTargetNode || node instanceof Invoke || node instanceof FullInfopointNode || node instanceof ParameterNode || node instanceof ReturnNode || super.requiresProcessing(node);
    }

    protected boolean virtualize(ValueNode valueNode, VirtualizerTool virtualizerTool) {
        if (valueNode instanceof ParameterNode) {
            return this.a((ParameterNode)valueNode, virtualizerTool);
        }
        if (valueNode instanceof FullInfopointNode) {
            return i.a((FullInfopointNode)valueNode, virtualizerTool);
        }
        if (valueNode instanceof ReturnNode) {
            return this.a((ReturnNode)valueNode, virtualizerTool);
        }
        if (valueNode instanceof SubstrateMethodCallTargetNode) {
            return this.a((SubstrateMethodCallTargetNode)valueNode, virtualizerTool);
        }
        if (valueNode instanceof Invoke) {
            return this.a((Invoke)valueNode, virtualizerTool);
        }
        return super.virtualize(valueNode, virtualizerTool);
    }

    private boolean a(ParameterNode parameterNode, VirtualizerTool virtualizerTool) {
        this.debug.log(3, ">> %s", (Object)parameterNode);
        if (this.uZ.ft()) {
            return false;
        }
        NodeInputList nodeInputList = this.uZ.vt.arguments();
        ValueNode valueNode2 = (ValueNode)nodeInputList.get(parameterNode.index());
        PartialEscapeSelectiveInliningPhase.h h2 = PartialEscapeSelectiveInliningPhase.h.b(valueNode2, this.uZ.vs);
        if (h2 == null) {
            return false;
        }
        this.fn().ifPresent(e2 -> {
            e2.vG.put(parameterNode, h2.vP);
            this.uZ.vq.a(h2.vP, (int n2) -> {
                e2.vG.remove(parameterNode);
                this.debug.log(3, ">> Materialization: Removed virtual parameter %d from %s", parameterNode.index(), e2);
            });
            this.debug.log(3, ">> %s: Parameter %d: Import ObjectState for caller argument %s", (Object)parameterNode, (Object)parameterNode.index(), (Object)valueNode2);
        });
        Object[] objectArray = (ValueNode[])Arrays.stream(h2.vQ).map(valueNode -> {
            Object object = valueNode instanceof ConstantNode ? (ValueNode)valueNode.copyWithInputs(false) : new a(valueNode.stamp(NodeView.DEFAULT), (ValueNode)valueNode);
            return (ValueNode)parameterNode.graph().addOrUniqueWithInputs((Node)object);
        }).toArray(ValueNode[]::new);
        VirtualObjectNode virtualObjectNode = h2.vP.duplicate();
        assert (parameterNode.stamp(NodeView.DEFAULT).javaType(this.uY.getMetaAccess()).isAssignableFrom(virtualObjectNode.type()));
        virtualizerTool.createVirtualObject(virtualObjectNode, (ValueNode[])objectArray, Collections.emptyList(), null, false);
        virtualizerTool.replaceWithVirtual(virtualObjectNode);
        if (this.debug.isLogEnabled(3)) {
            this.debug.log(3, ">> %s: Parameter %d: Replaced with %s, %s", (Object)parameterNode, (Object)parameterNode.index(), (Object)virtualObjectNode, (Object)Arrays.toString(objectArray));
        }
        return true;
    }

    private static boolean a(FullInfopointNode fullInfopointNode, VirtualizerTool virtualizerTool) {
        fullInfopointNode.getDebug().log(5, ">> %s: Remove ", (Object)fullInfopointNode);
        virtualizerTool.delete();
        return true;
    }

    private boolean a(ReturnNode returnNode, VirtualizerTool virtualizerTool) {
        this.debug.log(3, ">> %s", (Object)returnNode);
        ValueNode valueNode = returnNode.result();
        this.debug.log(3, ">> %s: With result %s", (Object)returnNode, (Object)valueNode);
        PartialEscapeSelectiveInliningPhase.h h2 = PartialEscapeSelectiveInliningPhase.h.b(valueNode, virtualizerTool);
        this.fn().ifPresent(e2 -> {
            ResolvedJavaMethod resolvedJavaMethod = returnNode.graph().method();
            int n2 = resolvedJavaMethod.getSignature().getParameterCount(!resolvedJavaMethod.isStatic());
            PartialEscapeSelectiveInliningPhase.g g2 = e2.vD.computeIfAbsent(returnNode, returnNode -> new PartialEscapeSelectiveInliningPhase.g(n2));
            if (e2.vH == PartialEscapeSelectiveInliningPhase.h.vR) {
                g2.vN = h2;
            }
            Map map = StreamSupport.stream(returnNode.graph().getNodes(ParameterNode.TYPE).spliterator(), false).collect(Collectors.toMap(AbstractLocalNode::index, Function.identity()));
            for (int i2 = 0; i2 < n2; ++i2) {
                ParameterNode parameterNode = (ParameterNode)map.get(i2);
                g2.vO[i2] = parameterNode != null ? PartialEscapeSelectiveInliningPhase.h.b((ValueNode)parameterNode, virtualizerTool) : PartialEscapeSelectiveInliningPhase.h.vS;
            }
        });
        boolean bl2 = h2 != null && this.uZ.ft();
        for (Invoke invoke : returnNode.graph().getInvokes()) {
            this.a(invoke).ifPresent(e2 -> {
                if (bl2) {
                    Set set = Collections.newSetFromMap(new IdentityHashMap());
                    for (Map.Entry<ParameterNode, VirtualObjectNode> entry : e2.vG.entrySet()) {
                        ParameterNode parameterNode = entry.getKey();
                        VirtualObjectNode virtualObjectNode = entry.getValue();
                        if (h2.vP.getObjectId() != virtualObjectNode.getObjectId()) continue;
                        this.debug.log(2, ">> %s: 2nd stage check (argument %d escaping) for %s", (Object)returnNode, (Object)parameterNode.index(), e2);
                        set.add(parameterNode);
                    }
                    set.forEach(e2.vG::remove);
                    if (e2.vH != null && h2.vP.getObjectId() == e2.vH.vP.getObjectId()) {
                        this.debug.log(2, ">> %s: 2nd stage check (returnResult escaping) for %s", (Object)returnNode, e2);
                        e2.vH = null;
                    }
                }
                if (e2.fv()) {
                    this.debug.log(2, ">> %s: Reject request (2nd stage) (no virtuals left) for %s", (Object)returnNode, e2);
                    this.b((PartialEscapeSelectiveInliningPhase.e)e2);
                }
            });
        }
        return false;
    }

    private boolean a(SubstrateMethodCallTargetNode substrateMethodCallTargetNode, VirtualizerTool virtualizerTool) {
        Object object;
        Object object2;
        if (this.debug.isLogEnabled(2)) {
            this.debug.log(2, ">>> %s: Try recursive analysis at depth %d (target %s, caller %s)", (Object)substrateMethodCallTargetNode, (Object)this.uZ.vr, (Object)PartialEscapeSelectiveInliningPhase.e(substrateMethodCallTargetNode.targetMethod()), (Object)PartialEscapeSelectiveInliningPhase.e(substrateMethodCallTargetNode.graph().method()));
        }
        if (!substrateMethodCallTargetNode.invoke().useForInlining()) {
            this.debug.log(3, ">>> %s:  Give up: Invoke explicitly marked as non-inlineable", (Object)substrateMethodCallTargetNode);
            return true;
        }
        if (this.uZ.vr > 3) {
            this.debug.log(3, ">>> %s:  Give up: Analysis recursion depth limit reached", (Object)substrateMethodCallTargetNode);
            return true;
        }
        b b2 = i.a(this.debug, substrateMethodCallTargetNode, virtualizerTool, this.uY.getMetaAccess());
        if (b2 == null) {
            this.debug.log(3, ">>> %s:  Give up: No single callee found", (Object)substrateMethodCallTargetNode);
            return true;
        }
        HostedMethod hostedMethod = b2.vd;
        ResolvedJavaType resolvedJavaType = b2.vc;
        if (this.debug.isLogEnabled(3)) {
            this.debug.log(3, ">>> %s:  Found single callee %s%s", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod), resolvedJavaType != null ? " with " + resolvedJavaType.getUnqualifiedName() : "");
        }
        for (ResolvedJavaType object32 : this.fm().vh) {
            if (!object32.isAssignableFrom((ResolvedJavaType)hostedMethod.getDeclaringClass())) continue;
            if (this.debug.isLogEnabled(3)) {
                this.debug.log(3, ">>> %s:  Give up: blacklist entry %s rejects %s", (Object)substrateMethodCallTargetNode, (Object)object32.toJavaName(), (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
            }
            return true;
        }
        if (!hostedMethod.canBeInlined()) {
            this.debug.log(3, ">>> %s:   Give up: Single callee cannot be inlined", (Object)substrateMethodCallTargetNode);
            return true;
        }
        Object object4 = this.uZ;
        while (object4 != null) {
            Optional<PartialEscapeSelectiveInliningPhase.e> optional = this.fn();
            if (optional.isPresent() && optional.get().vA.equals(hostedMethod)) {
                if (this.debug.isLogEnabled(3)) {
                    this.debug.log(3, ">>> %s:   Give up: Recursive call to single callee %s", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
                }
                return true;
            }
            object4 = ((PartialEscapeSelectiveInliningPhase.c)object4).vq;
        }
        StructuredGraph structuredGraph = hostedMethod.compilationInfo.createGraph(this.debug, (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
        if (structuredGraph == null) {
            if (this.debug.isLogEnabled(3)) {
                this.debug.log(3, ">>> %s:   Give up: No graph for single callee %s", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
            }
            return true;
        }
        List list = substrateMethodCallTargetNode.arguments().stream().map(valueNode -> PartialEscapeSelectiveInliningPhase.a(valueNode, virtualizerTool)).collect(Collectors.toList());
        long l2 = list.stream().filter(virtualObjectNode -> virtualObjectNode != null).count();
        boolean bl2 = i.x(hostedMethod) && i.j((Node)substrateMethodCallTargetNode.invoke().asNode());
        if ((l2 += bl2 ? 1L : 0L) == 0L) {
            if (this.debug.isLogEnabled(3)) {
                this.debug.log(3, ">>> %s:    Give up: No virtualized arguments and no virtualizable return value in single callee %s", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
            }
            return true;
        }
        int n2 = 165;
        int n4 = structuredGraph.getNodes().filter(ValueNode.class).count();
        if (this.debug.isLogEnabled(3)) {
            this.debug.log(3, ">>> %s:   NodeCount: %s has %d ValueNodes)", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod), (Object)n4);
        }
        if (n4 > n2) {
            if (this.debug.isLogEnabled(3)) {
                this.debug.log(3, ">>> %s:   Give up: Graph for single callee %s is too big (%d nodes)", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod), (Object)n4);
            }
            return true;
        }
        int n5 = this.fm().vk;
        if (n4 + this.fm().vj.fp() > n5) {
            if (this.debug.isLogEnabled(3)) {
                this.debug.log(3, ">>> %s:   Too many nodes after adding %s: total graph size would be %d nodes", (Object)substrateMethodCallTargetNode, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod), (Object)(n4 + this.fm().vj.fp()));
            }
            return true;
        }
        PartialEscapeSelectiveInliningPhase.c c2 = new PartialEscapeSelectiveInliningPhase.c(this.uZ, virtualizerTool, substrateMethodCallTargetNode);
        PartialEscapeSelectiveInliningPhase.e e2 = new PartialEscapeSelectiveInliningPhase.e(substrateMethodCallTargetNode.invoke(), hostedMethod, structuredGraph, resolvedJavaType, n4);
        if (bl2) {
            e2.vH = PartialEscapeSelectiveInliningPhase.h.vR;
        }
        this.a(e2);
        this.debug.log(2, ">>> %s:   Accept request (%d canditate(s)) %s", (Object)substrateMethodCallTargetNode, (Object)l2, (Object)e2);
        if (this.debug.isLogEnabled(3)) {
            this.debug.log(3, ">>> %s: Recursive analysis (%d, %s): Begin {{{", (Object)substrateMethodCallTargetNode, (Object)c2.vr, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
        }
        PartialEscapeSelectiveInliningPhase partialEscapeSelectiveInliningPhase = new PartialEscapeSelectiveInliningPhase(c2.vu, structuredGraph.getOptions());
        partialEscapeSelectiveInliningPhase.a(structuredGraph, this.uY, c2);
        if (this.debug.isLogEnabled(3)) {
            this.debug.log(3, ">>> %s: Recursive analysis (%d, %s): }}} End", (Object)substrateMethodCallTargetNode, (Object)c2.vr, (Object)PartialEscapeSelectiveInliningPhase.e((ResolvedJavaMethod)hostedMethod));
        }
        Iterator<PartialEscapeSelectiveInliningPhase.e> iterator = e2.vF.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            this.debug.log(2, ">> %s: Reevaluate nested %s", (Object)substrateMethodCallTargetNode, object2);
            if (!((PartialEscapeSelectiveInliningPhase.e)object2).fv()) continue;
            this.debug.log(2, ">> %s: Reject request (2nd stage) (no virtuals left) for %s", (Object)substrateMethodCallTargetNode, object2);
            ((PartialEscapeSelectiveInliningPhase.e)object2).a(this.fm().vj);
            iterator.remove();
        }
        assert (e2.vD.size() <= 1);
        object2 = e2.vD.keySet().iterator();
        e2.vI = 0;
        if (object2.hasNext()) {
            ReturnNode returnNode = (ReturnNode)object2.next();
            object = e2.vD.get(returnNode);
            this.debug.log(3, ">>> %s: ReturnState %s: ResultState %s", (Object)substrateMethodCallTargetNode, (Object)returnNode, (Object)((PartialEscapeSelectiveInliningPhase.g)object).vN);
            for (int i2 = 0; i2 < ((PartialEscapeSelectiveInliningPhase.g)object).vO.length; ++i2) {
                PartialEscapeSelectiveInliningPhase.h h2 = ((PartialEscapeSelectiveInliningPhase.g)object).vO[i2];
                VirtualObjectNode virtualObjectNode2 = (VirtualObjectNode)list.get(i2);
                if (h2 == PartialEscapeSelectiveInliningPhase.h.vS && virtualObjectNode2 != null) {
                    this.debug.log(3, ">>> %s: ReturnState %s: Parameter %d: Found unused virtual argument", (Object)substrateMethodCallTargetNode, (Object)returnNode, (Object)i2);
                    ++e2.vI;
                    int n6 = i2;
                    this.uZ.a(virtualObjectNode2, (int n3) -> {
                        --e2.vI;
                        this.debug.log(3, ">> Materialization: Removed unused virtual parameter %d from %s", n6, (Object)e2);
                    });
                }
                this.debug.log(3, ">>> %s: ReturnState %s: Parameter %d: State %s", (Object)substrateMethodCallTargetNode, (Object)returnNode, (Object)i2, (Object)h2);
            }
        }
        boolean bl3 = true;
        object = null;
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        for (Map.Entry<ReturnNode, PartialEscapeSelectiveInliningPhase.g> entry : e2.vD.entrySet()) {
            ReturnNode returnNode = entry.getKey();
            PartialEscapeSelectiveInliningPhase.g g2 = entry.getValue();
            PartialEscapeSelectiveInliningPhase.h h3 = g2.vN;
            if (h3 != null) {
                object = h3;
            } else {
                bl3 = false;
            }
            for (ParameterNode parameterNode : e2.vG.keySet()) {
                PartialEscapeSelectiveInliningPhase.h h4 = g2.vO[parameterNode.index()];
                if (h4 != null) continue;
                this.debug.log(3, ">>> %s: Initially virtual Parameter %s got materialized as %s at %s", (Object)substrateMethodCallTargetNode, (Object)parameterNode, (Object)h4, (Object)returnNode);
                set.add(parameterNode);
            }
        }
        if (object == null) {
            bl3 = false;
        }
        int n7 = e2.vG.size() + e2.vI;
        set.forEach(e2.vG::remove);
        if (bl3) {
            assert (e2.vH == PartialEscapeSelectiveInliningPhase.h.vR);
            e2.vH = object;
        } else {
            e2.vH = null;
        }
        int n8 = e2.vI + e2.vG.size() + (bl3 ? 1 : 0);
        if (n8 > 0) {
            this.debug.log(3, ">>> %s: Some passed-in arguments are still virtual for %s", (Object)substrateMethodCallTargetNode, (Object)e2);
            return false;
        }
        if (this.debug.isLogEnabled(2)) {
            this.debug.log(2, ">>> %s: Reject request (1st stage) (%d mat of %d virtual) for %s", (Object)substrateMethodCallTargetNode, (Object)set.size(), (Object)n7, (Object)e2);
        }
        this.b(e2);
        return true;
    }

    private static boolean j(Node node2) {
        return node2.usages().filter(node -> !(node instanceof VirtualState)).isNotEmpty();
    }

    private static boolean x(HostedMethod hostedMethod) {
        return hostedMethod.getSignature().getReturnKind().isObject();
    }

    private boolean a(Invoke invoke, VirtualizerTool virtualizerTool) {
        ValueNode[] valueNodeArray;
        this.debug.log(3, ">>> %s", (Object)invoke);
        Optional<PartialEscapeSelectiveInliningPhase.e> optional = this.a(invoke);
        if (!optional.isPresent()) {
            return true;
        }
        PartialEscapeSelectiveInliningPhase.e e2 = optional.get();
        this.debug.log(3, ">>> %s: Handle %s", (Object)invoke, (Object)e2);
        IdentityHashMap<ReturnNode, PartialEscapeSelectiveInliningPhase.g> identityHashMap = e2.vD;
        PartialEscapeSelectiveInliningPhase.h h2 = e2.vH;
        if (h2 != null) {
            assert (h2 != PartialEscapeSelectiveInliningPhase.h.vR);
            valueNodeArray = (ValueNode[])Arrays.stream(h2.vQ).map(valueNode -> {
                Object object = identityHashMap.size() == 1 && valueNode instanceof ConstantNode ? (ValueNode)valueNode.copyWithInputs(false) : new a(valueNode.stamp(NodeView.DEFAULT).unrestricted(), (ValueNode)valueNode);
                return (ValueNode)invoke.asNode().graph().addOrUniqueWithInputs((Node)object);
            }).toArray(ValueNode[]::new);
            VirtualObjectNode virtualObjectNode = h2.vP.duplicate();
            virtualizerTool.createVirtualObject(virtualObjectNode, valueNodeArray, Collections.emptyList(), null, false);
            virtualizerTool.replaceWithVirtual(virtualObjectNode);
            e2.vH = PartialEscapeSelectiveInliningPhase.h.a(virtualObjectNode, virtualizerTool);
            this.uZ.a(e2.vH.vP, (int n2) -> {
                e2.vH = null;
                this.debug.log(3, ">> Materialization: Removed virtualReturnResult from %s", (Object)e2);
            });
            this.debug.log(3, ">>> %s: Replaced with result %s", (Object)invoke, (Object)e2.vH);
        }
        valueNodeArray = invoke.callTarget().arguments();
        for (int i2 = 0; i2 < valueNodeArray.size(); ++i2) {
            int n3;
            ValueNode valueNode2 = (ValueNode)valueNodeArray.get(i2);
            VirtualObjectNode virtualObjectNode = PartialEscapeSelectiveInliningPhase.a(valueNode2, virtualizerTool);
            if (virtualObjectNode == null) continue;
            boolean bl2 = !identityHashMap.isEmpty();
            boolean bl3 = true;
            PartialEscapeSelectiveInliningPhase.h h3 = null;
            for (PartialEscapeSelectiveInliningPhase.g g2 : identityHashMap.values()) {
                h3 = g2.vO[i2];
                if (h3 != null) {
                    bl3 = false;
                    continue;
                }
                bl2 = false;
            }
            boolean bl4 = bl2 && identityHashMap.size() == 1;
            boolean bl5 = !bl2 && !bl3;
            this.debug.log(2, ">>> %s: Parameter %d, paramAllVirtual %b, numStates %d", (Object)invoke, (Object)i2, (Object)bl2, (Object)identityHashMap.size());
            if (h3 == PartialEscapeSelectiveInliningPhase.h.vS && bl4 && !bl5) {
                if (!this.debug.isLogEnabled(2)) continue;
                this.debug.log(2, ">>> %s: Skip adjusting unused argument #%d to: %s", (Object)invoke, (Object)i2, (Object)PartialEscapeSelectiveInliningPhase.h.b(valueNode2, virtualizerTool));
                continue;
            }
            ValueNode[] valueNodeArray2 = new ValueNode[virtualObjectNode.entryCount()];
            for (n3 = 0; n3 < virtualObjectNode.entryCount(); ++n3) {
                ValueNode valueNode3;
                ValueNode valueNode4 = virtualizerTool.getEntry(virtualObjectNode, n3);
                a a2 = bl4 && (valueNode3 = h3.vQ[n3]) instanceof ConstantNode ? (ValueNode)valueNode3.copyWithInputs(false) : new a(valueNode4.stamp(NodeView.DEFAULT).unrestricted(), valueNode4);
                a2 = (ValueNode)invoke.asNode().graph().addOrUniqueWithInputs((Node)a2);
                virtualizerTool.setVirtualEntry(virtualObjectNode, n3, (ValueNode)a2);
                valueNodeArray2[n3] = a2;
            }
            if (bl5) {
                if (this.debug.isLogEnabled(2)) {
                    this.debug.log(2, ">>> %s: Trigger materialization for argument #%d to: %s", (Object)invoke, (Object)i2, (Object)PartialEscapeSelectiveInliningPhase.h.a(virtualObjectNode, virtualizerTool));
                }
                n3 = virtualizerTool.ensureMaterialized(virtualObjectNode) ? 1 : 0;
                assert (n3 != 0);
            }
            if (!this.debug.isLogEnabled(2)) continue;
            this.debug.log(2, ">>> %s: Adjusted argument #%d to: %s", (Object)invoke, (Object)i2, (Object)PartialEscapeSelectiveInliningPhase.h.b(valueNode2, virtualizerTool));
        }
        return false;
    }

    private Optional<PartialEscapeSelectiveInliningPhase.e> a(Invoke invoke) {
        return this.fm().vj.c(invoke);
    }

    private Optional<PartialEscapeSelectiveInliningPhase.e> fn() {
        return Optional.ofNullable(this.uZ.vt).flatMap(substrateMethodCallTargetNode -> this.a(substrateMethodCallTargetNode.invoke()));
    }

    private void a(PartialEscapeSelectiveInliningPhase.e e4) {
        this.fm().vj.c(e4.vy).ifPresent(e2 -> {
            this.debug.log(3, ">>> Before adding, first remove previous: %s", e2);
            this.b((PartialEscapeSelectiveInliningPhase.e)e2);
        });
        this.fn().ifPresent(e3 -> e3.vF.add(e4));
        this.fm().vj.a(e4.vy, e4);
    }

    private void b(PartialEscapeSelectiveInliningPhase.e e2) {
        e2.vH = null;
        e2.a(this.fm().vj);
        this.fn().ifPresent(e3 -> e3.vF.remove(e2));
    }

    protected boolean ensureMaterialized(PartialEscapeBlockState<?> partialEscapeBlockState, int n2, FixedNode fixedNode, GraphEffectList graphEffectList, CounterKey counterKey) {
        boolean bl2 = super.ensureMaterialized(partialEscapeBlockState, n2, fixedNode, graphEffectList, counterKey);
        List list = this.uZ.vw.getOrDefault(n2, Collections.emptyList());
        this.uZ.vw.remove(n2);
        for (IntConsumer intConsumer : list) {
            intConsumer.accept(n2);
        }
        return bl2;
    }

    protected PartialEscapeBlockState.Final fo() {
        StructuredGraph structuredGraph = this.cfg.graph;
        return new PartialEscapeBlockState.Final(structuredGraph.getOptions(), structuredGraph.getDebug());
    }

    protected PartialEscapeBlockState.Final a(PartialEscapeBlockState.Final final_) {
        return new PartialEscapeBlockState.Final(final_);
    }

    public boolean hasChanged() {
        return false;
    }

    public void applyEffects() {
    }

    protected /* synthetic */ Object cloneState(Object object) {
        return this.a((PartialEscapeBlockState.Final)object);
    }

    protected /* synthetic */ Object getInitialState() {
        return this.fo();
    }

    private static class b {
        private final ResolvedJavaType vc;
        private final HostedMethod vd;

        b(ResolvedJavaType resolvedJavaType, HostedMethod hostedMethod) {
            this.vc = resolvedJavaType;
            this.vd = hostedMethod;
        }
    }

    @NodeInfo(size=NodeSize.SIZE_IGNORED, cycles=NodeCycles.CYCLES_IGNORED)
    protected static class com.oracle.svm.enterprise.hosted.phases.i$a
    extends FloatingNode
    implements NodeWithIdentity {
        public static final NodeClass<com.oracle.svm.enterprise.hosted.phases.i$a> TYPE = NodeClass.create(com.oracle.svm.enterprise.hosted.phases.i$a.class);
        protected final a va;

        protected com.oracle.svm.enterprise.hosted.phases.i$a(Stamp stamp, ValueNode valueNode) {
            super(TYPE, stamp);
            this.va = new a(valueNode);
        }

        static class a {
            ValueNode vb;

            a(ValueNode valueNode) {
                this.vb = valueNode;
            }
        }
    }
}

