/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.jitprofiling.vtune;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.code.CompilationResultFrameTree;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.jitprofiling.vtune.Jitprofiling;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class VTuneDynamicCodeObserver
implements InstalledCodeObserver {
    private final DebugContext xU;
    private final CompilationResult xV;
    private final Pointer xW;
    private int xX;
    private final Path xY;

    VTuneDynamicCodeObserver(DebugContext debugContext, CompilationResult compilationResult, Pointer pointer) {
        this.xU = debugContext;
        this.xV = compilationResult;
        this.xW = pointer;
        this.xY = VTuneDynamicCodeObserver.gl();
    }

    private static Path gl() {
        String string = (String)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneRuntimeSourceDestDir.getValue();
        if (string != null) {
            return Path.of(string, new String[0]);
        }
        Path path = Path.of("sources", new String[0]);
        Path path2 = Path.of(ProcessProperties.getExecutableName(), new String[0]).getParent();
        if (path2 != null) {
            path = path2.resolve(path);
        }
        return path;
    }

    public InstalledCodeObserver.InstalledCodeObserverHandle install() {
        if (Jitprofiling.iJIT_IsProfilingActive() != Jitprofiling.a.iJIT_SAMPLING_ON) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        Object object = this.xV.getName();
        if (object == null || ((String)object).isEmpty()) {
            object = "UnnamedCU";
        }
        object = "jit " + (String)object;
        CompilationResultFrameTree.CallNode callNode = new CompilationResultFrameTree.Builder(this.xU, this.xV.getTargetCodeSize(), Integer.MAX_VALUE, true, true).build(this.xV);
        if (callNode == null) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        this.xX = 0;
        new d().a((String)object, callNode);
        if (this.xX == 0) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)WordFactory.nullPointer();
        }
        JITMethodHandle jITMethodHandle = (JITMethodHandle)UnmanagedMemory.malloc((int)SizeOf.get(JITMethodHandle.class));
        jITMethodHandle.setAccessor((InstalledCodeObserver.InstalledCodeObserverHandleAccessor)ImageSingletons.lookup(b.class));
        jITMethodHandle.setJitMethodID(this.xX);
        return jITMethodHandle;
    }

    private String a(StackTraceElement stackTraceElement) {
        Path path = this.xY.resolve(VTuneDynamicCodeObserver.b(stackTraceElement));
        if (((Boolean)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneAbsoluteFilenames.getValue()).booleanValue()) {
            try {
                return path.toAbsolutePath().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path.toString();
    }

    private static String b(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        String string2 = string.substring(0, Math.max(0, string.lastIndexOf(46)));
        StringBuilder stringBuilder = new StringBuilder(string2.replace('.', File.separatorChar));
        if (stringBuilder.length() > 0) {
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.append(stackTraceElement.getFileName());
        return stringBuilder.toString();
    }

    private static String a(CompilationResultFrameTree.CallNode callNode) {
        return callNode.frame.getMethod().format("%H:%n(%P)").replace(".", ":");
    }

    private final class d
    implements CompilationResultFrameTree.Visitor {
        private CCharPointer yf;

        private d() {
        }

        public void a(String string, CompilationResultFrameTree.CallNode callNode) {
            try (DebugContext.Scope scope = VTuneDynamicCodeObserver.this.xU.scope((Object)"VTuneEventsEmitter", (Object)callNode);){
                VTuneDynamicCodeObserver.this.xU.log("Running VTuneEventsEmitter for %s", (Object)string);
                try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);){
                    this.yf = cCharPointerHolder.get();
                    callNode.visit((CompilationResultFrameTree.Visitor)this, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                throw VTuneDynamicCodeObserver.this.xU.handle(throwable);
            }
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            int n2;
            if (!(frameNode instanceof CompilationResultFrameTree.CallNode)) {
                return;
            }
            CompilationResultFrameTree.CallNode callNode = (CompilationResultFrameTree.CallNode)frameNode;
            if (objectArray.length == 0) {
                n2 = this.b(callNode);
            } else {
                int n3 = (Integer)objectArray[0];
                n2 = this.a(callNode, n3);
            }
            frameNode.visitChildren((CompilationResultFrameTree.Visitor)this, new Object[]{n2});
        }

        private int b(CompilationResultFrameTree.CallNode callNode) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.xU.log("%nEmitting METHOD_LOAD event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.xU.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.xU.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n2;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n3 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
                        Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)UnsafeStackValue.get((int)n3);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)WordFactory.unsigned((int)n3), (byte)0);
                        int n4 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n4 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Load_V22.set_method_id(n4);
                        iJIT_Method_Load_V22.set_module_name(this.yf);
                        iJIT_Method_Load_V22.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Load_V22.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.xW.add(callNode.getStartPos()));
                        iJIT_Method_Load_V22.set_method_size(callNode.getSpan());
                        iJIT_Method_Load_V22.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.xU);){
                            iJIT_Method_Load_V22.set_line_number_table(c2.ye.F(0));
                            iJIT_Method_Load_V22.set_line_number_size(c2.yd);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2(), iJIT_Method_Load_V22);
                        }
                        VMError.guarantee((VTuneDynamicCodeObserver.this.xX == 0 ? 1 : 0) != 0);
                        VTuneDynamicCodeObserver.this.xX = n4;
                        n2 = n4;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n2;
            }
        }

        private int a(CompilationResultFrameTree.CallNode callNode, int n2) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.xU.log("%nEmitting METHOD_LOAD_INLINE event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.xU.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.xU.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n3;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n4 = SizeOf.get(Jitprofiling.iJIT_Method_Inline_Load.class);
                        Jitprofiling.iJIT_Method_Inline_Load iJIT_Method_Inline_Load2 = (Jitprofiling.iJIT_Method_Inline_Load)UnsafeStackValue.get((int)n4);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Inline_Load2), (UnsignedWord)WordFactory.unsigned((int)n4), (byte)0);
                        int n5 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n5 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Inline_Load2.set_method_id(n5);
                        iJIT_Method_Inline_Load2.set_parent_method_id(n2);
                        iJIT_Method_Inline_Load2.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Inline_Load2.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.xW.add(callNode.getStartPos()));
                        iJIT_Method_Inline_Load2.set_method_size(callNode.getSpan());
                        iJIT_Method_Inline_Load2.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.xU);){
                            iJIT_Method_Inline_Load2.set_line_number_table(c2.ye.F(0));
                            iJIT_Method_Inline_Load2.set_line_number_size(c2.yd);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED(), iJIT_Method_Inline_Load2);
                        }
                        n3 = n5;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n3;
            }
        }
    }

    @RawStructure
    private static interface JITMethodHandle
    extends InstalledCodeObserver.InstalledCodeObserverHandle {
        @RawField
        public int getJitMethodID();

        @RawField
        public void setJitMethodID(int var1);
    }

    static class b
    implements InstalledCodeObserver.InstalledCodeObserverHandleAccessor {
        b() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void release(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            int n2 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
            Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)StackValue.get((int)n2);
            UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)WordFactory.unsigned((int)n2), (byte)0);
            iJIT_Method_Load_V22.set_method_id(((JITMethodHandle)installedCodeObserverHandle).getJitMethodID());
            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_UNLOAD_START(), iJIT_Method_Load_V22);
            ((UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class)).free((PointerBase)installedCodeObserverHandle);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void releaseOnTearDown(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            this.release(installedCodeObserverHandle);
        }
    }

    private static final class c
    implements CompilationResultFrameTree.Visitor,
    AutoCloseable {
        private final CompilationResultFrameTree.CallNode xZ;
        private final DebugContext ya;
        private PinnedObject yb;
        private CompilationResultFrameTree.FrameNode yc;
        int yd;
        Jitprofiling.LineNumberInfo ye;

        private c(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            this.xZ = callNode;
            this.ya = debugContext;
        }

        public static c a(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            c c2 = new c(callNode, debugContext);
            c2.yd = 0;
            c2.ye = (Jitprofiling.LineNumberInfo)WordFactory.nullPointer();
            c2.yc = null;
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            int n2 = SizeOf.get(Jitprofiling.LineNumberInfo.class) * c2.yd;
            debugContext.log(" Creating %d LineNumberInfo(s) (%d bytes) for %s", (Object)c2.yd, (Object)n2, (Object)callNode);
            c2.yb = PinnedObject.create((Object)new byte[n2]);
            c2.yd = 0;
            c2.ye = (Jitprofiling.LineNumberInfo)c2.yb.addressOfArrayElement(0);
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            return c2;
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            if (this.ye.isNonNull()) {
                Jitprofiling.LineNumberInfo lineNumberInfo = this.ye.F(this.yd);
                BytecodePosition bytecodePosition = frameNode.frame;
                if (frameNode != this.xZ && frameNode instanceof CompilationResultFrameTree.CallNode) {
                    bytecodePosition = bytecodePosition.getCaller();
                }
                StackTraceElement stackTraceElement = CompilationResultFrameTree.SourcePositionSupplier.getStackTraceElement((BytecodePosition)bytecodePosition);
                this.ya.log("  Write LineNumberInfo entry for: %s", (Object)frameNode);
                int n2 = stackTraceElement.getLineNumber();
                lineNumberInfo.setLineNumber(n2);
                int n3 = frameNode.getEndPos() - this.xZ.getStartPos();
                if (frameNode == this.xZ && this.yc != null) {
                    n3 = Math.max(0, this.yc.getStartPos() - this.xZ.getStartPos() - 1);
                }
                lineNumberInfo.setOffset(n3);
                this.ya.log("  LineNumberInfo lineNumber = %d, offset = %d", n2, n3);
                VMError.guarantee((n3 >= 0 ? 1 : 0) != 0, (String)"LineNumberInfo entry with negative offset makes no sense");
            } else if (frameNode != this.xZ && this.yc == null) {
                this.yc = frameNode;
            }
            ++this.yd;
        }

        @Override
        public void close() {
            this.yb.close();
        }
    }

    static final class a
    implements InstalledCodeObserver.Factory {
        a() {
        }

        public InstalledCodeObserver create(DebugContext debugContext, SharedMethod sharedMethod, CompilationResult compilationResult, Pointer pointer, int n2) {
            if (compilationResult == null) {
                return null;
            }
            return new VTuneDynamicCodeObserver(debugContext, compilationResult, pointer);
        }
    }
}

