/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingLoader;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.a;
import com.oracle.svm.enterprise.profiling.metadata.elements.c;
import com.oracle.svm.enterprise.profiling.metadata.elements.d;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingNativeImageConfigureProfile;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.nodes.ProfileData;

public final class ProfilingDetachedLoader
extends ProfilingLoader<Integer, Integer> {
    private static final Consumer<String> RUNTIME_EXCEPTION_CONSUMER = string -> {
        throw new RuntimeException((String)string);
    };
    private final Map<String, Integer> globalTypes = new HashMap<String, Integer>();
    private final Map<ProfilingMethodKey, Integer> globalMethods = new HashMap<ProfilingMethodKey, Integer>();

    @Override
    public boolean shouldIgnoreProfileVersionCheck() {
        return false;
    }

    @Override
    public e loadProfile(Path path) {
        return this.loadProfile0(path, RUNTIME_EXCEPTION_CONSUMER);
    }

    @Override
    public ProfilingBaseProfile newProfile(e e2, ProfileData.ProfileSource profileSource) {
        return new ProfilingNativeImageConfigureProfile(this, e2);
    }

    @Override
    public com.oracle.svm.enterprise.profiling.metadata.elements.b<d> getGlobalTypes() {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<d>(ProfilingDetachedLoader.sortMapById(this.globalTypes).map(entry -> new d((Integer)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList()));
    }

    @Override
    public com.oracle.svm.enterprise.profiling.metadata.elements.b<c> getGlobalMethods() {
        return new com.oracle.svm.enterprise.profiling.metadata.elements.b<c>(ProfilingDetachedLoader.sortMapById(this.globalMethods).map(entry -> new c((Integer)entry.getValue(), ((ProfilingMethodKey)entry.getKey()).methodName, ((ProfilingMethodKey)entry.getKey()).signature)).collect(Collectors.toList()));
    }

    @Override
    public Map<Integer, Integer> loadTypes(Map<Integer, d> map) {
        int n2 = this.globalTypes.size();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (d d2 : map.values()) {
            if (!this.globalTypes.containsKey(d2.getName())) {
                hashMap.put(d2.ho(), n2);
                this.globalTypes.put(d2.getName(), n2++);
                continue;
            }
            hashMap.put(d2.ho(), this.globalTypes.get(d2.getName()));
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Integer> loadMethods(Map<Integer, d> map, Map<Integer, c> map2) {
        int n2 = this.globalMethods.size();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (c c2 : map2.values()) {
            int[] nArray = (int[])c2.hp().clone();
            int n3 = nArray[0];
            if (!map.containsKey(n3)) continue;
            String string = map.get(n3).getName();
            nArray[0] = this.globalTypes.get(string);
            int n4 = nArray[1];
            if (!map.containsKey(n4)) continue;
            String string2 = map.get(n4).getName();
            nArray[1] = this.globalTypes.get(string2);
            boolean bl2 = true;
            for (int i2 = 2; i2 < nArray.length; ++i2) {
                if (!map.containsKey(nArray[i2])) {
                    bl2 = false;
                    break;
                }
                String string3 = map.get(nArray[i2]).getName();
                nArray[i2] = this.globalTypes.get(string3);
            }
            if (!bl2) continue;
            ProfilingMethodKey profilingMethodKey = new ProfilingMethodKey(c2.getName(), nArray);
            if (!this.globalMethods.containsKey(profilingMethodKey)) {
                hashMap.put(c2.ho(), n2);
                this.globalMethods.put(profilingMethodKey, n2++);
                continue;
            }
            hashMap.put(c2.ho(), this.globalMethods.get(profilingMethodKey));
        }
        return hashMap;
    }

    @Override
    protected BiFunction<Integer, Integer, a<?>> getCodePositionGenerator(b b2, byte by) {
        return (n2, n3) -> b2.a((int)n2, (int)n3, by);
    }

    private static <T> Stream<Map.Entry<T, Integer>> sortMapById(Map<T, Integer> map) {
        return map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue));
    }

    private record ProfilingMethodKey(String methodName, int[] signature) {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ProfilingMethodKey profilingMethodKey = (ProfilingMethodKey)object;
            return Objects.equals(this.methodName, profilingMethodKey.methodName) && Arrays.equals(this.signature, profilingMethodKey.signature);
        }

        @Override
        public int hashCode() {
            int n2 = Objects.hash(this.methodName);
            n2 = 31 * n2 + Arrays.hashCode(this.signature);
            return n2;
        }
    }
}

