/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.sbom;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.h;
import com.oracle.svm.enterprise.sbom.a;
import com.oracle.svm.enterprise.sbom.c;
import com.oracle.svm.enterprise.sbom.g;
import com.oracle.svm.enterprise.sbom.i;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.util.LogUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
public class d
implements InternalFeature {
    private static final String Bl = "com.oracle.svm";
    private static final String Bm = "com.oracle.svm";
    private static final String Bn = "svm";
    private static final String Bo = "oracle";
    private static final String Bp = "graalvm-native-image";
    private static final String Bq = "We could not find any version info for the following classes:";
    private static final String Br = "The image cannot be built while strict SBOM is enabled and version info is missing for these classes.";
    private static final String Bs = "A strict SBOM cannot be enabled without selecting an SBOM format.";
    private static final String Bt = "strict";
    private static final String Bu = "export";
    private static final String Bv = "pom.properties";
    private static final String Bw = "MANIFEST.MF";
    private static final String Bx = "sbom";
    private static final String By = "sbom_length";
    private static final String Bz = "An I/O error occurred while compressing the image's SBOM. If this issue persists, please report it.";
    private static final String BA = "cyclonedx,strict,export";
    private static final Set<String> BB = Set.of("jdk.internal", "jdk.zipfs", "jdk.localedata", "com.oracle.graal");
    private static final Set<String> BC = Set.of("MANIFEST.MF", "pom.properties");
    private static final List<String> BD = List.of("Bundle-SymbolicName", "Automatic-Module-Name");
    private static final List<String> BE = List.of("Implementation-Version", "Bundle-Version");

    private static void b(OptionKey<?> optionKey) {
        Set<String> set = d.hT();
        if (d.j(set) && !d.l(set)) {
            throw UserError.abort((String)"%s", (Object[])new Object[]{Bs});
        }
        set.removeAll(List.of("cyclonedx", Bt, Bu));
        if (!set.isEmpty()) {
            throw UserError.abort((String)"The SBOM option %s contains invalid value(s): %s. It can only contain %s.", (Object[])new Object[]{optionKey.getName(), String.join((CharSequence)", ", set), BA});
        }
    }

    private static Set<String> hT() {
        return new HashSet<String>(((LocatableMultiOptionValue.Strings)b.IncludeSBOM.getValue()).values());
    }

    private static boolean h(Set<String> set) {
        return !d.i(set);
    }

    private static boolean i(Set<String> set) {
        return set.isEmpty();
    }

    private static boolean j(Set<String> set) {
        return set.contains(Bt);
    }

    private static boolean k(Set<String> set) {
        return set.contains(Bu);
    }

    private static boolean l(Set<String> set) {
        return set.contains("cyclonedx");
    }

    private static int a(c c2) {
        Collection<com.oracle.svm.enterprise.sbom.a> collection = c2.hR();
        g g2 = c2.hS();
        String string = g2.a(collection);
        byte[] byArray = string.getBytes();
        try {
            int n2 = byArray.length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            UnsignedWord unsignedWord = WordFactory.unsigned((int)byArray2.length);
            CGlobalDataFeature.singleton().registerWithGlobalSymbol(CGlobalDataFactory.createBytes(() -> byArray2, (String)Bx));
            CGlobalDataFeature.singleton().registerWithGlobalSymbol(CGlobalDataFactory.createWord((WordBase)unsignedWord, (String)By));
            return byArray2.length;
        }
        catch (IOException iOException) {
            throw VMError.shouldNotReachHere((String)Bz);
        }
    }

    private static void a(c c2, Path path) {
        Collection<com.oracle.svm.enterprise.sbom.a> collection = c2.hR();
        g g2 = c2.hS();
        String string = g2.a(collection);
        String string2 = g2.hQ();
        String string3 = String.valueOf(path) + string2;
        try {
            FileWriter fileWriter = new FileWriter(string3);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw VMError.shouldNotReachHere((String)("Could not save SBOM to disk. Please check your output directory and report this issue if it persists: " + String.valueOf(iOException)));
        }
    }

    private static Optional<URI> j(Class<?> clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return Optional.empty();
        }
        URL uRL = codeSource.getLocation();
        if (uRL == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.empty();
        }
    }

    private static boolean V(String string) {
        for (String string2 : BB) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean W(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2) || c2 == '.') continue;
            return false;
        }
        return true;
    }

    private static Optional<Pair<Integer, Integer>> a(String string, char c2) {
        int n2 = string.lastIndexOf(c2);
        if (n2 == -1 || n2 == 0) {
            return Optional.empty();
        }
        int n3 = string.lastIndexOf(c2, n2 - 1);
        int n4 = n2 + 1;
        if (n3 == -1) {
            return Optional.of(Pair.create((Object)string.length(), (Object)n4));
        }
        return Optional.of(Pair.create((Object)n2, (Object)n4));
    }

    private static Pair<String, String> a(String string, Pair<Integer, Integer> pair) {
        String string2 = string.substring(0, (Integer)pair.getLeft());
        String string3 = string.substring((Integer)pair.getRight());
        return Pair.create((Object)string2, (Object)string3);
    }

    private static Optional<com.oracle.svm.enterprise.sbom.a> a(Class<?> clazz, Path path) {
        int n2;
        String string = clazz.getPackageName();
        Optional<Pair<Integer, Integer>> optional = d.a(string, '.');
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        Pair<Integer, Integer> pair = optional.get();
        Pair<String, String> pair2 = d.a(string, pair);
        String string2 = (String)pair2.getLeft();
        String string3 = (String)pair2.getRight();
        Path path2 = path.getFileName();
        if (path2 == null) {
            return Optional.empty();
        }
        String string4 = path2.toString();
        int n3 = n2 = string4.lastIndexOf(46);
        if (n2 <= 0) {
            return Optional.empty();
        }
        int n4;
        while ((n4 = string4.lastIndexOf(45, n3 - 1)) >= 0) {
            String string5 = string4.substring(n4 + 1, n3);
            if (d.W(string5)) {
                String string6 = string4.substring(n4 + 1, n2);
                i i2 = new i(string6, Bp);
                com.oracle.svm.enterprise.sbom.a a2 = new com.oracle.svm.enterprise.sbom.a(string2, string3, i2);
                return Optional.of(a2);
            }
            n3 = n4;
        }
        return Optional.empty();
    }

    private static Set<com.oracle.svm.enterprise.sbom.a> m(Set<com.oracle.svm.enterprise.sbom.a> set) {
        TreeSet<com.oracle.svm.enterprise.sbom.a> treeSet = new TreeSet<com.oracle.svm.enterprise.sbom.a>(new a.a());
        Iterator<com.oracle.svm.enterprise.sbom.a> iterator = set.iterator();
        com.oracle.svm.enterprise.sbom.a a2 = null;
        while (iterator.hasNext()) {
            if (a2 == null) {
                a2 = iterator.next();
                continue;
            }
            com.oracle.svm.enterprise.sbom.a a3 = iterator.next();
            if (a2.AT.equals(a3.AT) && a2.AU.equals(a3.AU)) {
                TreeSet<i> treeSet2 = new TreeSet<i>(i::a);
                treeSet2.addAll(a2.AV);
                treeSet2.addAll(a3.AV);
                a2 = new com.oracle.svm.enterprise.sbom.a(a2.AT, a2.AU, treeSet2);
                continue;
            }
            treeSet.add(a2);
            a2 = a3;
        }
        treeSet.add(a2);
        return treeSet;
    }

    private static Optional<Set<com.oracle.svm.enterprise.sbom.a>> a(Class<?> clazz, URI uRI, com.oracle.svm.enterprise.sbom.a a2) {
        try {
            String string = uRI.getScheme();
            if ("jrt".equals(string)) {
                TreeSet<com.oracle.svm.enterprise.sbom.a> treeSet = new TreeSet<com.oracle.svm.enterprise.sbom.a>(new a.a());
                String string2 = uRI.getPath();
                String string3 = string2.substring(1);
                Optional<Pair<Integer, Integer>> optional = d.a(string3, '.');
                if (optional.isEmpty()) {
                    return Optional.empty();
                }
                Pair<Integer, Integer> pair = optional.get();
                Pair<String, String> pair2 = d.a(string3, pair);
                String string4 = (String)pair2.getLeft();
                String string5 = (String)pair2.getRight();
                if (d.V(string4)) {
                    treeSet.add(a2);
                    return Optional.of(treeSet);
                }
                com.oracle.svm.enterprise.sbom.a a3 = new com.oracle.svm.enterprise.sbom.a(string4, string5, a2.hN());
                treeSet.add(a3);
                return Optional.of(treeSet);
            }
            Path path = Paths.get(uRI);
            if (Files.isDirectory(path, new LinkOption[0])) {
                return Optional.empty();
            }
            ClassLoader classLoader = null;
            final Optional<com.oracle.svm.enterprise.sbom.a> optional = d.a(clazz, path);
            FileSystem fileSystem = FileSystems.newFileSystem(path, classLoader);
            final TreeSet<com.oracle.svm.enterprise.sbom.a> treeSet = new TreeSet<com.oracle.svm.enterprise.sbom.a>(new a.a());
            SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(){

                public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) {
                    String string = null;
                    for (String string2 : BC) {
                        if (!path.endsWith(string2)) continue;
                        string = string2;
                        break;
                    }
                    if (string == null) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        Object object;
                        String string2;
                        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                        if (inputStream == null) {
                            return FileVisitResult.CONTINUE;
                        }
                        string2 = null;
                        String string3 = null;
                        SortedSet<i> sortedSet = new TreeSet<i>(i::a);
                        switch (string) {
                            case "pom.properties": {
                                Properties properties = new Properties();
                                properties.load(inputStream);
                                string2 = properties.getProperty("groupId");
                                string3 = properties.getProperty("artifactId");
                                String string4 = properties.getProperty("version");
                                sortedSet.add(new i(string4, d.Bv));
                                break;
                            }
                            case "MANIFEST.MF": {
                                String string5;
                                Manifest manifest = new Manifest(inputStream);
                                Attributes attributes = manifest.getMainAttributes();
                                String string6 = null;
                                Optional<Pair<Integer, Integer>> optional2 = BD.iterator();
                                while (optional2.hasNext() && (string6 = attributes.getValue(string5 = optional2.next())) == null) {
                                }
                                if (string6 == null) {
                                    return FileVisitResult.CONTINUE;
                                }
                                optional2 = d.a(string6, '.');
                                if (optional2.isEmpty()) {
                                    return FileVisitResult.CONTINUE;
                                }
                                string5 = (Pair)optional2.get();
                                string2 = string6.substring(0, (Integer)string5.getLeft());
                                string3 = string6.substring((Integer)string5.getRight());
                                for (String string7 : BE) {
                                    String string8 = attributes.getValue(string7);
                                    if (string8 == null) continue;
                                    sortedSet.add(new i(string8, d.Bw));
                                    break;
                                }
                                if (sortedSet.size() != 0) break;
                            }
                        }
                        if (string2 == null || string3 == null || sortedSet.size() == 0) {
                            if (optional.isEmpty()) {
                                return FileVisitResult.CONTINUE;
                            }
                            object = (com.oracle.svm.enterprise.sbom.a)optional.get();
                            if (string2 == null) {
                                string2 = ((com.oracle.svm.enterprise.sbom.a)object).AT;
                            }
                            if (string3 == null) {
                                string3 = ((com.oracle.svm.enterprise.sbom.a)object).AU;
                            }
                            if (sortedSet.size() == 0) {
                                sortedSet = ((com.oracle.svm.enterprise.sbom.a)object).AV;
                            }
                        }
                        object = new com.oracle.svm.enterprise.sbom.a(string2, string3, sortedSet);
                        treeSet.add(object);
                    }
                    catch (IOException iOException) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.a((Path)object, basicFileAttributes);
                }
            };
            Files.walkFileTree(fileSystem.getPath("/META-INF", new String[0]), (FileVisitor<? super Path>)simpleFileVisitor);
            if (treeSet.size() == 0) {
                if (optional.isPresent()) {
                    TreeSet<com.oracle.svm.enterprise.sbom.a> treeSet2 = new TreeSet<com.oracle.svm.enterprise.sbom.a>(new a.a());
                    treeSet2.add(optional.get());
                    return Optional.of(treeSet2);
                }
                return Optional.empty();
            }
            Set<com.oracle.svm.enterprise.sbom.a> set = d.m(treeSet);
            return Optional.of(set);
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    private static boolean X(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("com.oracle.svm");
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        Object object;
        Comparable<URI> comparable;
        Object object2;
        String string;
        Object object32;
        Set<String> set = d.hT();
        FeatureImpl.AfterAnalysisAccessImpl afterAnalysisAccessImpl = (FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess;
        List list = afterAnalysisAccessImpl.getUniverse().getTypes();
        HashSet<Class> hashSet = new HashSet<Class>();
        HashSet<URI> hashSet2 = new HashSet<URI>();
        String string2 = ((VM)ImageSingletons.lookup(VM.class)).version;
        i i2 = new i(string2, Bp);
        com.oracle.svm.enterprise.sbom.a a2 = new com.oracle.svm.enterprise.sbom.a("com.oracle.svm", Bn, i2, Bo, Bp, null);
        final TreeSet<com.oracle.svm.enterprise.sbom.a> treeSet = new TreeSet<com.oracle.svm.enterprise.sbom.a>(new a.a());
        treeSet.add(a2);
        HashSet<Class> hashSet3 = new HashSet<Class>();
        for (Object object32 : list) {
            boolean bl2;
            Class clazz;
            if (!object32.isReachable() || (clazz = object32.getJavaClass()) == null || hashSet.contains(clazz)) continue;
            hashSet.add(clazz);
            try {
                string = clazz.getCanonicalName();
            }
            catch (Throwable throwable) {
                string = null;
            }
            if ((bl2 = d.X(string)) || ((Optional)(object2 = d.j(clazz))).isEmpty() || hashSet2.contains(comparable = ((Optional)object2).get())) continue;
            Optional<Set<com.oracle.svm.enterprise.sbom.a>> optional = d.a(clazz, (URI)comparable, a2);
            hashSet2.add((URI)comparable);
            if (optional.isEmpty()) {
                if (!d.h(set) || string == null) continue;
                hashSet3.add(clazz);
                continue;
            }
            treeSet.addAll((Collection<com.oracle.svm.enterprise.sbom.a>)optional.get());
        }
        if (hashSet3.size() > 0) {
            object = new StringBuilder();
            for (Class clazz : hashSet3) {
                string = clazz.getCanonicalName();
                if (string == null) continue;
                ((StringBuilder)object).append(System.lineSeparator());
                ((StringBuilder)object).append(string);
            }
            LogUtils.warning((String)(Bq + String.valueOf(object)));
            if (d.j(set)) {
                throw UserError.abort((String)Br, (Object[])new Object[0]);
            }
        }
        object = d.i(set) ? new a() : new com.oracle.svm.enterprise.sbom.b();
        object32 = new c(treeSet, (g)object);
        ImageSingletons.add(c.class, (Object)object32);
        if (d.i(set)) {
            return;
        }
        final int n2 = d.a((c)object32);
        ImageSingletons.add(h.b.class, (Object)new h.b(){

            @Override
            public int dp() {
                return n2;
            }

            @Override
            public int dq() {
                return treeSet.size();
            }
        });
        if (d.k(set)) {
            string = (String)SubstrateOptions.Path.getValue();
            String string3 = (String)SubstrateOptions.Name.getValue();
            if (string == null) {
                object2 = Paths.get(string3, new String[0]);
            } else {
                comparable = Paths.get(string, new String[0]);
                object2 = comparable.resolve(string3);
            }
            d.a((c)object32, (Path)object2);
        }
    }

    public static final class b {
        @APIOption(name={"enable-sbom"}, defaultValue={"cyclonedx"})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeSBOM = new HostedOptionKey((Object)LocatableMultiOptionValue.Strings.buildWithCommaDelimiter(), d::b);
    }

    private static class a
    implements g {
        private a() {
        }

        @Override
        public String a(Collection<com.oracle.svm.enterprise.sbom.a> collection) {
            return "";
        }

        @Override
        public String hQ() {
            return "";
        }
    }
}

