/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import java.util.Arrays;

public enum ConfigurationFile {
    REACHABILITY_METADATA("reachability-metadata", null, true, true),
    REFLECTION("reflect", "reflection", true, false),
    RESOURCES("resource", "resources", true, false),
    SERIALIZATION("serialization", "serialization", true, false),
    JNI("jni", "jni", true, false),
    DYNAMIC_PROXY("proxy", null, true, false),
    PREDEFINED_CLASSES_NAME("predefined-classes", null, true, false),
    FOREIGN("foreign", null, false, false),
    SERIALIZATION_DENY("serialization-deny", null, false, false);

    public static final String LEGACY_FILE_NAME_SUFFIX = "-config.json";
    public static final String COMBINED_FILE_NAME_SUFFIX = ".json";
    private final String name;
    private final String fieldName;
    private final boolean canAgentGenerate;
    private final boolean combinedFile;
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_SUBDIR = "agent-extracted-predefined-classes";
    public static final String PREDEFINED_CLASSES_AGENT_EXTRACTED_NAME_SUFFIX = ".classdata";
    public static final String PARTIAL_CONFIGURATION_WITH_ORIGINS = "partial-config-with-origins.json";
    private static final ConfigurationFile[] agentGeneratedFiles;

    private ConfigurationFile(String name, String fieldName, boolean canAgentGenerate, boolean combinedFile) {
        this.name = name;
        this.fieldName = fieldName;
        this.canAgentGenerate = canAgentGenerate;
        this.combinedFile = combinedFile;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFileName() {
        return this.name + (this.combinedFile ? COMBINED_FILE_NAME_SUFFIX : LEGACY_FILE_NAME_SUFFIX);
    }

    public String getFileName(String suffix) {
        return this.name + suffix;
    }

    public boolean canBeGeneratedByAgent() {
        return this.canAgentGenerate && !this.combinedFile;
    }

    public static ConfigurationFile getByName(String name) {
        for (ConfigurationFile file : ConfigurationFile.values()) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        return null;
    }

    public static ConfigurationFile[] agentGeneratedFiles() {
        return agentGeneratedFiles;
    }

    private static ConfigurationFile[] computeAgentGeneratedFiles() {
        return (ConfigurationFile[])Arrays.stream(ConfigurationFile.values()).filter(f -> f.canBeGeneratedByAgent()).toArray(ConfigurationFile[]::new);
    }

    static {
        agentGeneratedFiles = ConfigurationFile.computeAgentGeneratedFiles();
    }
}

