/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckNode;
import com.oracle.svm.core.meta.SharedMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

final class InsertStackOverflowCheckPhase
extends BasePhase<MidTierContext> {
    InsertStackOverflowCheckPhase() {
    }

    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        SharedMethod method = (SharedMethod)graph.method();
        if (((SubstrateBackend)context.getTargetProvider()).stackOverflowCheckedInPrologue(method) || !StackOverflowCheckImpl.needStackOverflowCheck(method)) {
            return;
        }
        StackOverflowCheckNode stackOverflowCheckNode = (StackOverflowCheckNode)graph.add((Node)new StackOverflowCheckNode());
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)stackOverflowCheckNode);
    }
}

