/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.util.UserError;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class HeapSizeVerifier {
    public static void verifyHeapOptions() {
        UnsignedWord minHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MinHeapSize.getValue());
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        UnsignedWord maxNewSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxNewSize.getValue());
        HeapSizeVerifier.verifyMaxHeapSizeAgainstAddressSpace(maxHeapSize);
        HeapSizeVerifier.verifyMinHeapSizeAgainstAddressSpace(minHeapSize);
        HeapSizeVerifier.verifyMaxNewSizeAgainstAddressSpace(maxNewSize);
        HeapSizeVerifier.verifyMinHeapSizeAgainstMaxHeapSize(minHeapSize);
        HeapSizeVerifier.verifyMaxNewSizeAgainstMaxHeapSize(maxHeapSize);
    }

    public static void verifyMinHeapSizeAgainstAddressSpace(UnsignedWord minHeapSize) throws UserError.UserException {
        HeapSizeVerifier.verifyAgainstAddressSpace(minHeapSize, "minimum heap size");
    }

    public static void verifyMaxHeapSizeAgainstAddressSpace(UnsignedWord maxHeapSize) throws UserError.UserException {
        HeapSizeVerifier.verifyAgainstAddressSpace(maxHeapSize, "maximum heap size");
    }

    public static void verifyMaxNewSizeAgainstAddressSpace(UnsignedWord maxNewSize) {
        HeapSizeVerifier.verifyAgainstAddressSpace(maxNewSize, "maximum new generation size");
    }

    private static void verifyAgainstAddressSpace(UnsignedWord actualValue, String actualValueName) {
        UnsignedWord addressSpaceSize = ReferenceAccess.singleton().getAddressSpaceSize();
        if (actualValue.aboveThan(addressSpaceSize)) {
            HeapSizeVerifier.throwError(actualValue, actualValueName, addressSpaceSize, "largest possible address space");
        }
    }

    private static void verifyMinHeapSizeAgainstMaxHeapSize(UnsignedWord minHeapSize) {
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        if (maxHeapSize.notEqual(0) && minHeapSize.aboveThan(maxHeapSize)) {
            HeapSizeVerifier.throwError(minHeapSize, "minimum heap size", maxHeapSize, "maximum heap size");
        }
    }

    private static void verifyMaxNewSizeAgainstMaxHeapSize(UnsignedWord maxNewSize) {
        UnsignedWord maxHeapSize = WordFactory.unsigned((long)SubstrateGCOptions.MaxHeapSize.getValue());
        if (maxHeapSize.notEqual(0) && maxNewSize.aboveThan(maxHeapSize)) {
            HeapSizeVerifier.throwError(maxNewSize, "maximum new generation size", maxHeapSize, "maximum heap size");
        }
    }

    private static void throwError(UnsignedWord actualValue, String actualValueName, UnsignedWord maxValue, String maxValueName) throws UserError.UserException {
        if (SubstrateUtil.HOSTED) {
            throw UserError.abort("The specified %s (%s) is larger than the %s (%s).", actualValueName, HeapSizeVerifier.format(actualValue), maxValueName, HeapSizeVerifier.format(maxValue));
        }
        throw new IllegalArgumentException("The specified " + actualValueName + " (" + HeapSizeVerifier.format(actualValue) + ") is larger than the " + maxValueName + " (" + HeapSizeVerifier.format(maxValue) + ").");
    }

    private static String format(UnsignedWord bytes) {
        int index;
        String[] units = new String[]{"", "k", "m", "g", "t"};
        UnsignedWord value = bytes;
        for (index = 0; value.unsignedRemainder(1024).equal(0) && index < units.length - 1; ++index) {
            value = value.unsignedDivide(1024);
        }
        return value.rawValue() + units[index];
    }
}

