/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.target;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK19OrEarlier;
import com.oracle.svm.core.jdk.JDK20OrLater;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.reflect.target.Name_jdk_internal_reflect_SerializationConstructorAccessorGenerator_helper;
import com.oracle.svm.core.reflect.target.Target_jdk_internal_reflect_SerializationConstructorAccessorImpl;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(classNameProvider=Name_jdk_internal_reflect_SerializationConstructorAccessorGenerator_helper.class)
final class Target_jdk_internal_reflect_SerializationConstructorAccessorGenerator {
    Target_jdk_internal_reflect_SerializationConstructorAccessorGenerator() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK20OrLater.class})
    public Target_jdk_internal_reflect_SerializationConstructorAccessorImpl generateSerializationConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, int modifiers, Class<?> targetConstructorClass) {
        return this.generateSerializationConstructor(declaringClass, parameterTypes, null, modifiers, targetConstructorClass);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrEarlier.class})
    public Target_jdk_internal_reflect_SerializationConstructorAccessorImpl generateSerializationConstructor(Class<?> declaringClass, Class<?>[] parameterTypes, Class<?>[] checkedExceptions, int modifiers, Class<?> targetConstructorClass) {
        SerializationRegistry serializationRegistry = (SerializationRegistry)ImageSingletons.lookup(SerializationRegistry.class);
        Object constructorAccessor = serializationRegistry.getSerializationConstructorAccessor(declaringClass, targetConstructorClass);
        return (Target_jdk_internal_reflect_SerializationConstructorAccessorImpl)constructorAccessor;
    }
}

