/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.libc;

import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.c.libc.LibCSpecific;
import com.oracle.svm.hosted.image.AbstractImage;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

public interface HostedLibCBase
extends LibCBase {
    public static HostedLibCBase singleton() {
        return (HostedLibCBase)ImageSingletons.lookup(LibCBase.class);
    }

    public static boolean containsLibCAnnotation(AnnotatedElement element) {
        return AnnotationAccess.getAnnotation((AnnotatedElement)element, LibCSpecific.class) != null;
    }

    public static boolean isProvidedInCurrentLibc(AnnotatedElement element) {
        LibCSpecific targetLibC = (LibCSpecific)AnnotationAccess.getAnnotation((AnnotatedElement)element, LibCSpecific.class);
        if (targetLibC == null) {
            return false;
        }
        LibCBase currentLibC = (LibCBase)ImageSingletons.lookup(LibCBase.class);
        for (Class<? extends LibCBase> aClass : targetLibC.value()) {
            if (!aClass.isAssignableFrom(currentLibC.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlatformEquivalent(Class<? extends Platform> platformClass) {
        Platform platform = (Platform)ImageSingletons.lookup(Platform.class);
        String simpleName = platformClass.getSimpleName();
        return simpleName.toLowerCase().equals(platform.getOS()) || Platform.includedIn(platformClass);
    }

    public static boolean isTypeProvidedInCurrentLibc(Class<?> clazz) {
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getEnclosingClass()) {
            if (!HostedLibCBase.containsLibCAnnotation(currentClazz)) continue;
            return HostedLibCBase.isProvidedInCurrentLibc(currentClazz);
        }
        Package clazzPackage = clazz.getPackage();
        if (clazzPackage != null) {
            return !HostedLibCBase.containsLibCAnnotation(clazz) || HostedLibCBase.isProvidedInCurrentLibc(clazzPackage);
        }
        return true;
    }

    public static boolean isMethodProvidedInCurrentLibc(Method method) {
        if (HostedLibCBase.containsLibCAnnotation(method) && !HostedLibCBase.isProvidedInCurrentLibc(method)) {
            return false;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return HostedLibCBase.isTypeProvidedInCurrentLibc(declaringClass);
    }

    public String getTargetCompiler();

    public List<String> getAdditionalQueryCodeCompilerOptions();

    default public List<String> getAdditionalLinkerOptions(AbstractImage.NativeImageKind imageKind) {
        return List.of();
    }

    public boolean requiresLibCSpecificStaticJDKLibraries();

    default public void checkIfLibCSupported() {
    }
}

