/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionRegistryAdapter
extends RegistryAdapter {
    private final RuntimeReflectionSupport reflectionSupport;

    ReflectionRegistryAdapter(RuntimeReflectionSupport reflectionSupport, ImageClassLoader classLoader) {
        super((ReflectionRegistry)reflectionSupport, classLoader);
        this.reflectionSupport = reflectionSupport;
    }

    @Override
    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives) {
        TypeResult<Class<?>> result = super.resolveType(condition, typeDescriptor, allowPrimitives);
        if (!result.isPresent()) {
            Throwable classLookupException = result.getException();
            if (classLookupException instanceof LinkageError) {
                this.reflectionSupport.registerClassLookupException(condition, typeDescriptor.toString(), classLookupException);
            } else if (MissingRegistrationUtils.throwMissingRegistrationErrors() && classLookupException instanceof ClassNotFoundException) {
                this.reflectionSupport.registerClassLookup(condition, typeDescriptor.toString());
            }
        }
        return result;
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllClassesQuery(condition, type);
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredClassesQuery(condition, type);
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllRecordComponentsQuery(condition, type);
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllPermittedSubclassesQuery(condition, type);
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllNestMembersQuery(condition, type);
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllSignersQuery(condition, type);
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        ((ReflectionDataBuilder)this.reflectionSupport).registerAllFieldsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        ((ReflectionDataBuilder)this.reflectionSupport).registerAllDeclaredFieldsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllMethodsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredMethodsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllConstructorsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredConstructorsQuery(condition, queriedOnly, type);
    }

    @Override
    public void registerField(ConfigurationCondition condition, Class<?> type, String fieldName, boolean allowWrite) throws NoSuchFieldException {
        try {
            super.registerField(condition, type, fieldName, allowWrite);
        }
        catch (NoSuchFieldException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerFieldLookup(condition, type, fieldName);
            }
            throw e;
        }
    }

    @Override
    public void registerMethod(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, String methodName, List<Class<?>> methodParameterTypes) throws NoSuchMethodException {
        try {
            super.registerMethod(condition, queriedOnly, type, methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerMethodLookup(condition, type, methodName, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }

    @Override
    public void registerConstructor(ConfigurationCondition condition, boolean queriedOnly, Class<?> type, List<Class<?>> methodParameterTypes) throws NoSuchMethodException {
        try {
            super.registerConstructor(condition, queriedOnly, type, methodParameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                this.reflectionSupport.registerConstructorLookup(condition, type, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
            }
            throw e;
        }
    }
}

