/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.CCLinkerInvocation;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.Platform;

public abstract class NativeImageViaCC
extends NativeImage {
    public NativeImageViaCC(AbstractImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, imageClassLoader);
    }

    private static List<String> diagnoseLinkerFailure(String linkerOutput) {
        Pattern p;
        Matcher m;
        ArrayList<String> potentialCauses = new ArrayList<String>();
        if (linkerOutput.contains("access beyond end of merged section")) {
            potentialCauses.add("Native Image is using a linker that appears to be incompatible with the tool chain used to build the JDK static libraries. The latter is typically shown in the output of `java -Xinternalversion`.");
        }
        if (SubstrateOptions.ForceNoROSectionRelocations.getValue().booleanValue() && (linkerOutput.contains("fatal error: cannot find ") || linkerOutput.contains("error: invalid linker name in argument"))) {
            potentialCauses.add(SubstrateOptions.ForceNoROSectionRelocations.getName() + " option cannot be used if ld.gold linker is missing from the host system");
        }
        if ((m = (p = Pattern.compile(".*cannot find -l([^\\s]+)\\s.*", 32)).matcher(linkerOutput)).matches()) {
            boolean targetWindows = Platform.includedIn(Platform.WINDOWS.class);
            String libPrefix = targetWindows ? "" : "lib";
            String libSuffix = targetWindows ? ".lib" : ".a";
            potentialCauses.add(String.format("It appears as though %s%s%s is missing. Please install it.", libPrefix, m.group(1), libSuffix));
        }
        return potentialCauses;
    }

    @Override
    public LinkerInvocation write(DebugContext debug, Path outputDirectory, Path tempDirectory, String imageName, FeatureImpl.BeforeImageWriteAccessImpl config, ForkJoinPool forkJoinPool) {
        try (Indent indent = debug.logAndIndent("Writing native image");){
            this.codeCache.purge();
            this.write(debug, tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()), forkJoinPool);
            if (NativeImageOptions.ExitAfterRelocatableImageWrite.getValue().booleanValue()) {
                LinkerInvocation linkerInvocation = null;
                return linkerInvocation;
            }
            LinkerInvocation inv = CCLinkerInvocation.getLinkerInvocation(this.imageKind, this.nativeLibs, this.codeCache.getCCInputFiles(tempDirectory, imageName), outputDirectory, tempDirectory, imageName, this.codeCache.getSymbols(this.getObjectFile()));
            for (Function<LinkerInvocation, LinkerInvocation> fn : config.getLinkerInvocationTransformers()) {
                inv = fn.apply(inv);
            }
            try {
                List<String> cmd = inv.getCommand();
                this.runLinkerCommand(imageName, inv, cmd, this.imageKind.isExecutable);
            }
            catch (RuntimeException e) {
                if (inv.shouldRunFallback(e.getMessage())) {
                    List<String> cmd = inv.getFallbackCommand();
                    this.runLinkerCommand(imageName, inv, cmd, this.imageKind.isExecutable);
                }
                throw e;
            }
            LinkerInvocation linkerInvocation = inv;
            return linkerInvocation;
        }
    }

    private void runLinkerCommand(String imageName, LinkerInvocation inv, List<String> cmd, boolean imageKindIsExecutable) {
        Process linkerProcess = null;
        String commandLine = SubstrateUtil.getShellCommandString(cmd, false);
        try {
            List<String> lines;
            ProcessBuilder linkerCommand = FileUtils.prepareCommand(cmd, inv.getTempDirectory());
            linkerCommand.redirectErrorStream(true);
            FileUtils.traceCommand(linkerCommand);
            linkerProcess = linkerCommand.start();
            try (InputStream inputStream = linkerProcess.getInputStream();){
                lines = FileUtils.readAllLines(inputStream);
                FileUtils.traceCommandOutput(lines);
            }
            int status = linkerProcess.waitFor();
            if (status != 0) {
                String output = String.join((CharSequence)System.lineSeparator(), lines);
                throw NativeImageViaCC.handleLinkerFailure("Linker command exited with " + status, commandLine, output);
            }
            Path imagePath = inv.getOutputFile();
            this.imageFileSize = (int)imagePath.toFile().length();
            BuildArtifacts.singleton().add(imageKindIsExecutable ? BuildArtifacts.ArtifactType.EXECUTABLE : BuildArtifacts.ArtifactType.SHARED_LIBRARY, imagePath);
            if (Platform.includedIn(Platform.WINDOWS.class) && !imageKindIsExecutable) {
                Path importLib = inv.getTempDirectory().resolve(imageName + ".lib");
                Path importLibCopy = Files.copy(importLib, imagePath.resolveSibling(importLib.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.IMPORT_LIBRARY, importLibCopy);
            }
            if (SubstrateOptions.useDebugInfoGeneration()) {
                BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, SubstrateOptions.getDebugInfoSourceCacheRoot());
                if (Platform.includedIn(Platform.WINDOWS.class)) {
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, imagePath.resolveSibling(imageName + ".pdb"));
                } else if (!SubstrateOptions.StripDebugInfo.getValue().booleanValue()) {
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.DEBUG_INFO, imagePath);
                }
            }
        }
        catch (IOException e) {
            throw NativeImageViaCC.handleLinkerFailure(e.toString(), commandLine, null);
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding("Interrupted during native-image linking step for " + imageName);
        }
        finally {
            if (linkerProcess != null) {
                linkerProcess.destroy();
            }
        }
    }

    private static RuntimeException handleLinkerFailure(String message, String commandLine, String output) {
        List<Object> potentialCauses;
        Formatter buf = new Formatter();
        buf.format("There was an error linking the native image: %s%n%n", message);
        List<Object> list = potentialCauses = output == null ? Collections.emptyList() : NativeImageViaCC.diagnoseLinkerFailure(output);
        if (!potentialCauses.isEmpty()) {
            int causeNum = 1;
            buf.format("Based on the linker command output, possible reasons for this include:%n", new Object[0]);
            for (String string : potentialCauses) {
                buf.format("%d. %s%n", causeNum, string);
                ++causeNum;
            }
            buf.format("%n", new Object[0]);
        }
        buf.format("Linker command executed:%n%s", commandLine);
        if (output != null) {
            buf.format("%n%nLinker command output:%n%s", output);
        }
        throw new RuntimeException(buf.toString());
    }
}

