/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.reflect.ComputeVTableOffset;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.reflect.ReflectionExpandSignatureMethod;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.reflect.SignatureKey;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.AnnotationExtractor;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticallyRegisteredFeature
public class ReflectionFeature
implements InternalFeature,
ReflectionSubstitutionSupport {
    private static final Method findCallerSensitiveAdapterMethod = JavaVersionUtil.JAVA_SPEC <= 17 ? null : ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.reflect.DirectMethodHandleAccessor"), (String)"findCSMethodAdapter", (Class[])new Class[]{Method.class});
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;
    private AnalysisUniverse aUniverse;
    private int loadedConfigurations;
    private UniverseMetaAccess metaAccess;
    final Map<Executable, SubstrateAccessor> accessors = new ConcurrentHashMap<Executable, SubstrateAccessor>();
    private final Map<SignatureKey, MethodPointer> expandSignatureMethods = new ConcurrentHashMap<SignatureKey, MethodPointer>();
    private static final Method invokePrototype = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototype", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method invokePrototypeForCallerSensitiveAdapter = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototypeForCallerSensitiveAdapter", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class, Class.class});
    private static final Method methodHandleInvokeErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"methodHandleInvokeError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method newInstanceErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"newInstanceError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;

    @Override
    public SubstrateAccessor getOrCreateAccessor(Executable member) {
        SubstrateAccessor existing = this.accessors.get(member);
        if (existing != null) {
            return existing;
        }
        if (this.analysisAccess == null) {
            throw VMError.shouldNotReachHere("New Method or Constructor found as reachable after static analysis: " + String.valueOf(member));
        }
        return this.accessors.computeIfAbsent(member, this::createAccessor);
    }

    private SubstrateAccessor createAccessor(Executable member) {
        MethodPointer expandSignature;
        MethodPointer directTarget = null;
        DynamicHub initializeBeforeInvoke = null;
        if (member instanceof Method) {
            MethodPointer expandSignature2;
            int vtableOffset = -1;
            Class<?> receiverType = null;
            boolean callerSensitiveAdapter = false;
            if (member.getDeclaringClass() == MethodHandle.class && (member.getName().equals("invoke") || member.getName().equals("invokeExact"))) {
                expandSignature2 = this.register((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)methodHandleInvokeErrorMethod), "Registered in " + String.valueOf(ReflectionFeature.class));
            } else {
                Method target = (Method)member;
                if (JavaVersionUtil.JAVA_SPEC > 17) {
                    try {
                        Method adapter = (Method)findCallerSensitiveAdapterMethod.invoke(null, member);
                        if (adapter != null) {
                            target = adapter;
                            callerSensitiveAdapter = true;
                        }
                    }
                    catch (ReflectiveOperationException ex) {
                        throw VMError.shouldNotReachHere(ex);
                    }
                }
                expandSignature2 = this.createExpandSignatureMethod(target, callerSensitiveAdapter);
                AnalysisMethod targetMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)target);
                if (!targetMethod.isAbstract()) {
                    directTarget = this.register((ResolvedJavaMethod)targetMethod, "Reflection target, registered in " + String.valueOf(ReflectionFeature.class));
                }
                if (!targetMethod.canBeStaticallyBound()) {
                    vtableOffset = -559087615;
                    this.analysisAccess.registerAsRoot(targetMethod, false, "Accessor method for reflection, registered in " + String.valueOf(ReflectionFeature.class), new MultiMethod.MultiMethodKey[0]);
                }
                VMError.guarantee(directTarget != null || vtableOffset != -1, "Must have either a directTarget or a vtableOffset");
                if (!targetMethod.isStatic()) {
                    receiverType = target.getDeclaringClass();
                }
                if (targetMethod.isStatic() && !targetMethod.getDeclaringClass().isInitialized()) {
                    initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)targetMethod.getDeclaringClass());
                }
            }
            return new SubstrateMethodAccessor(member, receiverType, expandSignature2, directTarget, vtableOffset, initializeBeforeInvoke, callerSensitiveAdapter);
        }
        Class<?> holder = member.getDeclaringClass();
        if (Modifier.isAbstract(holder.getModifiers()) || holder.isInterface() || holder.isPrimitive() || holder.isArray()) {
            expandSignature = this.register((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)newInstanceErrorMethod), "Registered in " + String.valueOf(ReflectionFeature.class));
        } else {
            expandSignature = this.createExpandSignatureMethod(member, false);
            AnalysisMethod constructor = this.analysisAccess.getMetaAccess().lookupJavaMethod(member);
            AnalysisMethod factoryMethod = (AnalysisMethod)FactoryMethodSupport.singleton().lookup((UniverseMetaAccess)this.analysisAccess.getMetaAccess(), (ResolvedJavaMethod)constructor, false);
            directTarget = this.register((ResolvedJavaMethod)factoryMethod, "Factory method, registered in " + String.valueOf(ReflectionFeature.class));
            if (!constructor.getDeclaringClass().isInitialized()) {
                initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)constructor.getDeclaringClass());
            }
        }
        return new SubstrateConstructorAccessor(member, expandSignature, directTarget, initializeBeforeInvoke);
    }

    private MethodPointer createExpandSignatureMethod(Executable member, boolean callerSensitiveAdapter) {
        return this.expandSignatureMethods.computeIfAbsent(new SignatureKey(member, callerSensitiveAdapter), signatureKey -> {
            ResolvedJavaMethod prototype = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)(callerSensitiveAdapter ? invokePrototypeForCallerSensitiveAdapter : invokePrototype)).getWrapped();
            return this.register(new ReflectionExpandSignatureMethod("invoke_" + signatureKey.uniqueShortName(), prototype, signatureKey.isStatic, signatureKey.argTypes, signatureKey.returnKind, signatureKey.callerSensitiveAdapter), "Registered in " + String.valueOf(ReflectionFeature.class));
        });
    }

    private MethodPointer register(ResolvedJavaMethod method, String reason) {
        AnalysisMethod aMethod = method instanceof AnalysisMethod ? (AnalysisMethod)method : this.analysisAccess.getUniverse().lookup((JavaMethod)method);
        this.analysisAccess.registerAsRoot(aMethod, true, reason, new MultiMethod.MultiMethodKey[0]);
        return new MethodPointer((ResolvedJavaMethod)aMethod);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.reflect"});
        ImageSingletons.add(ReflectionSubstitutionSupport.class, (Object)this);
        this.reflectionData = new ReflectionDataBuilder((SubstrateAnnotationExtractor)ImageSingletons.lookup(AnnotationExtractor.class));
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ImageSingletons.add(ReflectionHostedSupport.class, (Object)this.reflectionData);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.aUniverse = access.getUniverse();
        this.reflectionData.duringSetup(access.getMetaAccess(), this.aUniverse);
        ReflectionConfigurationParser<Class<?>> parser = ConfigurationParserUtils.create("reflection", true, (ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, access.getImageClassLoader(), "reflection");
        ReflectionConfigurationParser<Class<?>> legacyParser = ConfigurationParserUtils.create(null, false, (ReflectionRegistry)this.reflectionData, access.getImageClassLoader());
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations(legacyParser, access.getImageClassLoader(), "reflection", ConfigurationFiles.Options.ReflectionConfigurationFiles, ConfigurationFiles.Options.ReflectionConfigurationResources, ConfigurationFile.REFLECTION.getFileName());
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.analysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        this.metaAccess = this.analysisAccess.getMetaAccess();
        this.reflectionData.beforeAnalysis(this.analysisAccess);
        this.reflectionData.flushConditionalConfiguration(access);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField(SubstrateMethodAccessor.class, (String)"vtableOffset"), (FieldValueTransformer)new ComputeVTableOffset());
        RuntimeReflection.register((Executable[])Object[].class.getMethods());
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reflectionData.flushConditionalConfiguration(access);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisAccess = null;
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest reflectionFallback;
        this.metaAccess = ((FeatureImpl.BeforeCompilationAccessImpl)access).getMetaAccess();
        if (ImageSingletons.contains(FallbackFeature.class) && (reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback) != null && this.loadedConfigurations == 0) {
            throw reflectionFallback;
        }
    }

    public HostedMetaAccess hostedMetaAccess() {
        return (HostedMetaAccess)this.metaAccess;
    }

    @Override
    public int getFieldOffset(Field field, boolean checkUnsafeAccessed) {
        VMError.guarantee(this.metaAccess instanceof HostedMetaAccess, "Field offsets are available only for compilation and afterwards.");
        HostedField hostedField = this.hostedMetaAccess().optionalLookupJavaField(field);
        if (hostedField == null || checkUnsafeAccessed && !hostedField.wrapped.isUnsafeAccessed()) {
            return -1;
        }
        return hostedField.getLocation();
    }

    @Override
    public String getDeletionReason(Field reflectionField) {
        ResolvedJavaField field = this.metaAccess.lookupJavaField(reflectionField);
        Delete annotation = (Delete)AnnotationAccess.getAnnotation((AnnotatedElement)field, Delete.class);
        return annotation != null ? annotation.value() : null;
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        FallbackFeature fallbackFeature = ImageSingletons.contains(FallbackFeature.class) ? (FallbackFeature)ImageSingletons.lookup(FallbackFeature.class) : null;
        ReflectionPlugins.registerInvocationPlugins(this.loader, snippetReflection, this.annotationSubstitutions, plugins.getClassInitializationPlugin(), plugins.getInvocationPlugins(), this.aUniverse, reason, fallbackFeature);
    }
}

