// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SerialAndEpsilonGCOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class SerialAndEpsilonGCOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlignedHeapChunkSize": {
            return OptionDescriptor.create(
                /*name*/ "AlignedHeapChunkSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of an aligned chunk. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "AlignedHeapChunkSize",
                /*option*/ SerialAndEpsilonGCOptions.AlignedHeapChunkSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapChunkHeaderPadding": {
            return OptionDescriptor.create(
                /*name*/ "HeapChunkHeaderPadding",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of bytes at the beginning of each heap chunk that are not used for payload data, i.e., can be freely used as metadata by the heap chunk provider. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "HeapChunkHeaderPadding",
                /*option*/ SerialAndEpsilonGCOptions.HeapChunkHeaderPadding,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LargeArrayThreshold": {
            return OptionDescriptor.create(
                /*name*/ "LargeArrayThreshold",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The size at or above which an array will be allocated in its own unaligned chunk. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "LargeArrayThreshold",
                /*option*/ SerialAndEpsilonGCOptions.LargeArrayThreshold,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumHeapSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumHeapSizePercent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum heap size as percent of physical memory. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "MaximumHeapSizePercent",
                /*option*/ SerialAndEpsilonGCOptions.MaximumHeapSizePercent,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumYoungGenerationSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumYoungGenerationSizePercent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of the young generation as a percentage of the maximum heap size. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "MaximumYoungGenerationSizePercent",
                /*option*/ SerialAndEpsilonGCOptions.MaximumYoungGenerationSizePercent,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "ZapChunks",
                /*option*/ SerialAndEpsilonGCOptions.ZapChunks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapConsumedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapConsumedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "After use, Fill memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "ZapConsumedHeapChunks",
                /*option*/ SerialAndEpsilonGCOptions.ZapConsumedHeapChunks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapProducedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapProducedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Before use, fill memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*declaringClass*/ SerialAndEpsilonGCOptions.class,
                /*fieldName*/ "ZapProducedHeapChunks",
                /*option*/ SerialAndEpsilonGCOptions.ZapProducedHeapChunks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 8;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlignedHeapChunkSize");
                    case 1: return get("HeapChunkHeaderPadding");
                    case 2: return get("LargeArrayThreshold");
                    case 3: return get("MaximumHeapSizePercent");
                    case 4: return get("MaximumYoungGenerationSizePercent");
                    case 5: return get("ZapChunks");
                    case 6: return get("ZapConsumedHeapChunks");
                    case 7: return get("ZapProducedHeapChunks");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
