/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jfr.JfrFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.truffle.runtime.jfr.EventFactory;
import com.oracle.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import java.util.Iterator;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class TruffleJFRFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        Iterator providers = TruffleRuntimeServices.load(EventFactory.Provider.class).iterator();
        if (!providers.hasNext()) {
            throw UserError.abort((String)"No EventFactory.Provider is registered in Truffle runtime services.", (Object[])new Object[0]);
        }
        EventFactory.Provider provider = (EventFactory.Provider)providers.next();
        EventFactory factory = provider.getEventFactory();
        ImageSingletons.add(EventFactory.class, (Object)factory);
    }

    public String getDescription() {
        return "Provides JFR flight recording for Truffle events.";
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return TruffleJFRFeature.isEnabled();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(TruffleFeature.class, JfrFeature.class);
    }

    private static boolean isEnabled() {
        return ImageSingletons.contains(TruffleFeature.class) && ImageSingletons.contains(JfrFeature.class) && JavaVersionUtil.JAVA_SPEC > 17;
    }
}

