/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.truffle.api.SubstrateTruffleField;
import com.oracle.svm.truffle.api.SubstrateTruffleMethod;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.truffle.compiler.ConstantFieldInfo;
import com.oracle.truffle.compiler.PartialEvaluationMethodInfo;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import java.lang.reflect.AnnotatedElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateTruffleUniverseFactory
extends SubstrateUniverseFactory {
    private final SubstrateTruffleRuntime truffleRuntime;
    private final ConcurrentMap<PartialEvaluationMethodInfo, PartialEvaluationMethodInfo> canonicalMethodInfos = new ConcurrentHashMap<PartialEvaluationMethodInfo, PartialEvaluationMethodInfo>();
    private final ConcurrentMap<ConstantFieldInfo, ConstantFieldInfo> canonicalFieldInfos = new ConcurrentHashMap<ConstantFieldInfo, ConstantFieldInfo>();

    public SubstrateTruffleUniverseFactory(SubstrateTruffleRuntime truffleRuntime) {
        this.truffleRuntime = truffleRuntime;
    }

    public SubstrateMethod createMethod(AnalysisMethod aMethod, HostedStringDeduplication stringTable) {
        PartialEvaluationMethodInfo peInfo = SubstrateTruffleUniverseFactory.createPartialEvaluationMethodInfo((TruffleCompilerRuntime)this.truffleRuntime, (ResolvedJavaMethod)aMethod);
        PartialEvaluationMethodInfo canonicalPeInfo = this.canonicalMethodInfos.computeIfAbsent(peInfo, k -> k);
        return new SubstrateTruffleMethod(aMethod, stringTable, canonicalPeInfo);
    }

    public SubstrateField createField(AnalysisField aField, HostedStringDeduplication stringTable) {
        ConstantFieldInfo fieldInfo = this.truffleRuntime.getConstantFieldInfo((ResolvedJavaField)aField);
        ConstantFieldInfo canonicalFieldInfo = fieldInfo == null ? null : this.canonicalFieldInfos.computeIfAbsent(fieldInfo, k -> k);
        return new SubstrateTruffleField(aField, stringTable, canonicalFieldInfo);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static PartialEvaluationMethodInfo createPartialEvaluationMethodInfo(TruffleCompilerRuntime runtime, ResolvedJavaMethod method) {
        Uninterruptible uninterruptibleAnnotation;
        PartialEvaluationMethodInfo info = ((SubstrateTruffleRuntime)runtime).getPartialEvaluationMethodInfo(method);
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method) && ((uninterruptibleAnnotation = Uninterruptible.Utils.getAnnotation((AnnotatedElement)method)) == null || !uninterruptibleAnnotation.mayBeInlined())) {
            return new PartialEvaluationMethodInfo(info.loopExplosion(), info.inlineForPartialEvaluation(), info.inlineForTruffleBoundary(), false, info.isSpecializationMethod());
        }
        return info;
    }
}

