/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.loader.FileUtil;
import com.oracle.jipher.internal.loader.LibraryLoader;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import com.oracle.jipher.internal.openssl.OpenSsl;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProviderException;
import java.util.List;

class DefaultJarLibLoader
extends LibraryLoader {
    static final String LOADING_MARKER_FILE = "jipher.ldg";
    FileUtil fileUtil;

    public DefaultJarLibLoader(LibraryLoaderContext ctx) {
        super(ctx);
        this.fileUtil = new FileUtil(ctx.getPlatform());
    }

    @Override
    public OpenSsl load() {
        List<String> libFiles = this.loadContext.getPlatform().getLibFiles();
        libFiles.add(this.loadContext.getPlatform().getOpensslCnfFile());
        String[] osslFiles = libFiles.toArray(new String[0]);
        URL[] urls = new URL[osslFiles.length];
        DEBUG.println("Attempting to locate libraries in classpath JAR file");
        for (int i = 0; i < osslFiles.length; ++i) {
            String resourcePath = this.loadContext.getPlatform().getResourcePath(osslFiles[i]);
            URL url = this.loadContext.getResourceClassLoader().getResource(resourcePath);
            if (url == null) {
                DEBUG.println("Did not find " + resourcePath + " in JAR file");
                throw new ProviderException("Could not find expected libraries in JAR for " + this.loadContext.getPlatform());
            }
            DEBUG.println("Found " + url);
            urls[i] = url;
        }
        return this.loadFromJar(osslFiles, urls);
    }

    OpenSsl loadFromJar(String[] osslFiles, URL[] urls) {
        OpenSsl openSsl;
        Path loadingFile;
        Path tmpDir;
        block8: {
            tmpDir = null;
            loadingFile = null;
            try {
                Path libTmpDir = Paths.get(this.loadContext.getLibTmpDir(), new String[0]);
                tmpDir = this.createNewTempDir(libTmpDir);
                loadingFile = this.fileUtil.createEmptyFile(tmpDir, LOADING_MARKER_FILE);
                for (int i = 0; i < osslFiles.length; ++i) {
                    Path tmpLibraryFile = tmpDir.resolve(osslFiles[i]);
                    String checksum = this.readChecksumValue(this.loadContext.getPlatform().getResourcePathChecksum(osslFiles[i]));
                    this.fileUtil.copyFile(urls[i], tmpLibraryFile);
                    this.verifyChecksum(checksum, tmpLibraryFile);
                }
                Path tmpLoadLib = tmpDir.resolve(this.loadContext.getPlatform().getLoadLibFile());
                this.loadContext.getSystemLoader().load(tmpLoadLib.toAbsolutePath().toString());
                openSsl = this.loadContext.configureOpenssl(tmpDir.toAbsolutePath().toString(), tmpDir.resolve(this.loadContext.getPlatform().getOpensslCnfFile()).toAbsolutePath().toString());
                if (loadingFile == null || tmpDir == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new ProviderException("Failed to load required libraries", e);
                }
                catch (Throwable throwable) {
                    if (loadingFile != null && tmpDir != null) {
                        for (String libFile : osslFiles) {
                            Path tmpLibraryFile = tmpDir.resolve(libFile);
                            this.fileUtil.tryDelete(tmpLibraryFile);
                        }
                    }
                    this.fileUtil.tryDelete(loadingFile);
                    this.fileUtil.tryDelete(tmpDir);
                    throw throwable;
                }
            }
            for (String libFile : osslFiles) {
                Path tmpLibraryFile = tmpDir.resolve(libFile);
                this.fileUtil.tryDelete(tmpLibraryFile);
            }
        }
        this.fileUtil.tryDelete(loadingFile);
        this.fileUtil.tryDelete(tmpDir);
        return openSsl;
    }

    private Path createNewTempDir(Path parent) throws IOException {
        Path tmpDir = parent.resolve(this.loadContext.genRandomDirName());
        int tries = 0;
        while (Files.exists(tmpDir, new LinkOption[0]) && tries++ < 3) {
            tmpDir = parent.resolve(this.loadContext.genRandomDirName());
        }
        if (Files.exists(tmpDir, new LinkOption[0])) {
            throw new IOException("Failed to create temporary directory");
        }
        DEBUG.println("Creating temporary directory to store libraries: " + tmpDir);
        this.fileUtil.createTempDirs(tmpDir);
        return tmpDir;
    }

    private String readChecksumValue(String checksumResource) throws IOException {
        URL checksumUrl = this.loadContext.getResourceClassLoader().getResource(checksumResource);
        return this.fileUtil.readString(checksumUrl, 8);
    }

    private void verifyChecksum(String expectedChecksum, Path libFile) throws IOException {
        String chk = this.fileUtil.computeChecksum(libFile);
        if (!expectedChecksum.equals(chk)) {
            DEBUG.println("Computed checksum of " + libFile + "(" + chk + ") did not match expected (" + expectedChecksum + ").");
            throw new ProviderException("Library file checksum verify failed: " + libFile.toString());
        }
    }
}

