/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.AlgType;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import java.security.ProviderException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class EvpKdf {
    private static final ConcurrentMap<String, Long> PREFETCHED_KDFS = new ConcurrentHashMap<String, Long>();

    static void clearPrefetchCache() {
        PREFETCHED_KDFS.clear();
    }

    static long fetch(OpenSsl openssl, String kdfAlg) {
        try {
            return openssl.evpFetch(AlgType.KDF.ordinal(), kdfAlg);
        }
        catch (OpenSslException e) {
            throw new ProviderException("Internal error", e);
        }
    }

    static long getEvpKdf(OpenSsl openssl, String kdfAlg) {
        return PREFETCHED_KDFS.computeIfAbsent(kdfAlg, alg -> EvpKdf.fetch(openssl, alg));
    }

    public static byte[] pbkdf2Derive(byte[] pass, int passLen, byte[] salt, int iter, MdAlg md, int keyLen) throws ProviderException {
        OpenSsl openssl = OsslFactory.get();
        long evpKdf = EvpKdf.getEvpKdf(openssl, "PBKDF2");
        try {
            return openssl.jphPbkdf2Derive(evpKdf, pass, passLen, salt, iter, md.getAlg(), keyLen);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static byte[] pkcs12Derive(byte[] pass, int passLen, byte[] salt, Pkcs12KdfId id, int iter, MdAlg md, int keyLen) throws ProviderException {
        OpenSsl openssl = OsslFactory.get();
        long evpKdf = EvpKdf.getEvpKdf(openssl, "PKCS12KDF");
        try {
            return openssl.jphPkcs12Derive(evpKdf, pass, passLen, salt, id.ordinal() + 1, iter, md.getAlg(), keyLen);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static byte[] tls1PrfDerive(byte[] secret, byte[] label, byte[] seed1, byte[] seed2, MdAlg md, int outLen) throws ProviderException {
        byte[] seed = new byte[label.length + seed1.length + (seed2 == null ? 0 : seed2.length)];
        System.arraycopy(label, 0, seed, 0, label.length);
        System.arraycopy(seed1, 0, seed, label.length, seed1.length);
        if (seed2 != null) {
            System.arraycopy(seed2, 0, seed, label.length + seed1.length, seed2.length);
        }
        OpenSsl openssl = OsslFactory.get();
        long evpKdf = EvpKdf.getEvpKdf(openssl, "TLS1-PRF");
        try {
            return openssl.jphTls1PrfDerive(evpKdf, secret, seed, md.getAlg(), outLen);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static enum Pkcs12KdfId {
        KEY,
        IV,
        MAC;

    }
}

