/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.common.Util;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.DSAParameterSpec;

final class DsaParamCache {
    private static final Debug DEBUG = Debug.getInstance("jipher");

    DsaParamCache() {
    }

    public static DSAParameterSpec get(int primeSize) {
        if (primeSize == 2048) {
            DEBUG.println("Getting default DSA parameters for 2048 bits");
            return new DSAParameterSpec(new BigInteger(1, Util.hexToBytes("00F82CD0B121DF91E2F9D1A84A9A89402A40B9544184E1FDBD27B045D122D719BF1CB7188330EA0E866D3DD2E779C81146316D7280DA9E09FFEA58F4219484B8E7C606F8C6C15F5BD87C21730CC83484495EF991980DCE1D704C6FFB7330B691CCEE948F39935BDF4A1E6CEDAAA6EF37C83868EA0FFA529537384E3595D14F50FF044F9BA38CED5AB1B291D29C8DD2DA43C711E662666FE0C241835E2100C08210FBF0E180F7941CD12C8D98BE70CD68FCC7F57D40EB447D68BA269F6A36E6672D232B59077AD48933C95924E81C524775C7EB5E4D2996C21D7714DA89CF76C91C6E48E3678B80C75CE90437B3C8608886BB9595876C200CA77E554E6E0F724B39")), new BigInteger(1, Util.hexToBytes("00879D04B33B22C098583DE711AF3C6CEAB0BEBB0AAC1B5B5203154EEB")), new BigInteger(1, Util.hexToBytes("25895D1722207B2E06032D0269587DFDA581800D5510A5605888A7E9868BCFE625CFB6CFF9641AE18BDF0595CC3A7668F014D7E9A818006F7A6E63B1919A25E41389249F0880A968CB5E63714CA3B7CACFFB1C27BE121F7E4122FB711FCEA26F7FE2645799A9AF6007D00F846B04242A1A9664F084BD06762C66BF2BB1E42CFDF5CAE58BD4796272150A304115ACF499FACF41F57225CA6EEDFCB909F0331B9719E5B80F18399A677D0574BED3FDEA92BD05524B0FBCED902B73A203E26A864C99994B19B7C93959E58D5623480349B4468B47975C0F8676F05A429DFE31D7FB9A100F73C8B17C151391C63E814F93F7F249B7E861C7958DF56D021063DEA150")));
        }
        if (primeSize == 3072) {
            DEBUG.println("Getting default DSA parameters for 3072 bits");
            return new DSAParameterSpec(new BigInteger(1, Util.hexToBytes("00B4E9351B2591E98FD2AA7A1CA493E8BD6E2DD66D1BBA15871CE860EFEE68B8AE7656E8C4D2C31F448C9F9E669D5675DC6891797F3027A1CD4F8B1E4B1B5E582D18CDFAED592A1C16E313CD9040A90926191D8EEA85A07A36F5D38518C90E601312289A755AD50ACDD302C834CC15BAA0583B8AADEE7FF1CABB28D4E7A4865460E04A0F04DD682A35D16B56B667EF8C0C83F9E734AC1BE4041C435BA032B29ABB2B1B0D4A814AD7A8D79DA3D53CEE7CF384A7E411FC8FD88E885F7AFBA91BC070483971A6DBA3E66A15D789285A788AA0EFDC0CCBC75B379A5F328353D2745541521B8E8030B0AE395B586A88AA2D591C3C303D509978E05292D0CF47298B14C42372C394B85208B6E3D80EBAB2B53D966523F645F1F0156FEC921C049758F8373AF0C400D761E5971C29A5720AE7419C785E7BC6BAFD00BA9A7DC75908CD423BBF323A092FE7BB71C77C10BA97FE1755D00D98FDFC49C86671202292D3E4AEC66E7544DAF07196C17AF4F40452B54B2E1494B9E3FD871F67B9ACCBFFA14C8C5D")), new BigInteger(1, Util.hexToBytes("0095527504A11CDD911A915EE8123BC1FE7B77EA7F9B694736907670D823AEA19D")), new BigInteger(1, Util.hexToBytes("00A5062CD5370449DE0274E7E9610D1F1212ADB33B78DBA9507DD62DD0BBE6CB1C00619192388F5FD705C2C25A2D90937BB294EA3D675651A8700575058DBC002C62BCD9781830AAE9DCA5ACE8E563B4B4A8752B5E9EAACE284233276B5EAA253F2529136B9B46B2FBA732BD9EBDCAA5581910A5DA161D12EFDCDBA15B5E3A60AE362F475C0666238B15EB1C3CFCA0D2BE85B75B47A4F790E58F977AA4FC48580EBBC16A0F83E9843568C886401B68025A078793F5114890D3FD0AAC5B2F55670013A460C052A3BBDFB72FE1E102F0B9B535DB93FAA281B9315BF5043269B1E6C29C10A31EDBD914E3014E25347790DC71212A1313EEE4DA9AA6F933E3AEFE8138DD0CAF20F87A75869082ED9AB8BD6E983E37F3DBFDE5E1C6DC4EC3331F649D3E72EB5005327C7D7C604CD751D5E579A8857515F810DDD01DD8B55BC3DFB57E79E2E2E2D1431D1DD3032598FBBBEFD7E354CFC854D3CBC37F5343B3BC6A2028374AE3B82746A7EB7BD7D4BD933F22B85DE33B6AC3B012C3205876C28EC072153B")));
        }
        throw new InvalidParameterException("No DSA parameters available for size " + primeSize + ", only 2048 and 3072 supported.");
    }
}

