/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.key.JceDhPrivateKey;
import com.oracle.jipher.internal.key.JceDhPublicKey;
import com.oracle.jipher.internal.key.JceEcPrivateKey;
import com.oracle.jipher.internal.key.JceEcPublicKey;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyCtx;
import com.oracle.jipher.internal.spi.DhKeyFactory;
import com.oracle.jipher.internal.spi.EcKeyFactory;
import com.oracle.jipher.internal.spi.NamedCurves;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyAgree
extends KeyAgreementSpi {
    private State state;
    private Object cleanable;
    private JceOsslKey key;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    abstract JceOsslKey checkPrivateKey(PrivateKey var1, AlgorithmParameterSpec var2) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract Pkey checkPublicKey(PublicKey var1) throws InvalidKeyException;

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Expected PrivateKey");
        }
        JceOsslKey priv = this.checkPrivateKey((PrivateKey)key, algorithmParameterSpec);
        Fips.enforcement().checkStrength(CryptoOp.KEYAGREE, priv);
        this.initInternal(priv);
    }

    private void initInternal(JceOsslKey key) {
        if (this.state != null) {
            this.clearSecret();
        }
        this.key = key;
    }

    private void checkInitialized() {
        if (this.key == null) {
            throw new IllegalStateException("KeyAgreement not initialized.");
        }
    }

    @Override
    protected Key engineDoPhase(Key peerKey, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!lastPhase) {
            throw new IllegalStateException("Multi-party key agreement not supported.");
        }
        this.checkInitialized();
        if (this.state != null) {
            this.clearSecret();
        }
        if (!(peerKey instanceof PublicKey)) {
            throw new InvalidKeyException("Expected PublicKey for doPhase");
        }
        try (PkeyCtx.Derive ctx = new PkeyCtx.Derive(this.key.getPkey());){
            Pkey pub = this.checkPublicKey((PublicKey)peerKey);
            this.state = new State(ctx.derive(pub));
            this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
            Key key = null;
            return key;
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException("secret not generated.");
        }
        byte[] ret = (byte[])this.state.secret.clone();
        this.clearSecret();
        return ret;
    }

    @Override
    protected int engineGenerateSecret(byte[] output, int offset) throws IllegalStateException, ShortBufferException {
        if (this.state == null) {
            throw new IllegalStateException("secret not generated.");
        }
        int len = this.state.secret.length;
        if (len > output.length - offset) {
            throw new ShortBufferException("output buffer too short.");
        }
        System.arraycopy(this.state.secret, 0, output, offset, len);
        this.clearSecret();
        return len;
    }

    private void clearSecret() {
        MultiRelease.clean(this.cleanable);
        this.state = null;
        this.cleanable = null;
    }

    @Override
    protected SecretKey engineGenerateSecret(String alg) throws IllegalStateException {
        if (this.state == null) {
            throw new IllegalStateException("secret not generated.");
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.state.secret, alg);
            return secretKeySpec;
        }
        finally {
            this.clearSecret();
        }
    }

    public static class DH
    extends KeyAgree {
        private final DhKeyFactory kf = new DhKeyFactory();

        @Override
        JceOsslKey checkPrivateKey(PrivateKey privKey, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            JceDhPrivateKey dhPriv = (JceDhPrivateKey)this.kf.engineTranslateKey(privKey);
            if (params != null) {
                if (!(params instanceof DHParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Parameters did not match key parameters");
                }
                if (!this.paramsEquals(dhPriv.getParams(), (DHParameterSpec)params)) {
                    throw new InvalidAlgorithmParameterException("Parameters did not match key parameters");
                }
            }
            return dhPriv;
        }

        @Override
        Pkey checkPublicKey(PublicKey pubKey) throws InvalidKeyException {
            JceDhPublicKey dhPriv = (JceDhPublicKey)this.kf.engineTranslateKey(pubKey);
            return dhPriv.getPkey();
        }

        boolean paramsEquals(DHParameterSpec spec1, DHParameterSpec spec2) {
            if (!spec1.getP().equals(spec2.getP())) {
                return false;
            }
            return spec1.getG().equals(spec2.getG());
        }
    }

    public static class ECDH
    extends KeyAgree {
        private final EcKeyFactory kf = new EcKeyFactory();

        @Override
        JceOsslKey checkPrivateKey(PrivateKey privKey, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            ECPrivateKey ecPrivKey;
            JceEcPrivateKey ecPriv = null;
            if (privKey instanceof ECPrivateKey && (ecPrivKey = (ECPrivateKey)privKey).getS() != null && ecPrivKey.getParams() != null) {
                ECPrivateKeySpec ecSpec = new ECPrivateKeySpec(ecPrivKey.getS(), ecPrivKey.getParams());
                try {
                    ecPriv = (JceEcPrivateKey)this.kf.engineGeneratePrivate(ecSpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeyException(e);
                }
            }
            if (ecPriv == null) {
                ecPriv = (JceEcPrivateKey)this.kf.translatePrivate(privKey);
            }
            if (params != null) {
                if (!(params instanceof ECParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Parameters did not match key parameters");
                }
                if (!NamedCurves.paramsEquals(ecPriv.getParams(), (ECParameterSpec)params)) {
                    throw new InvalidAlgorithmParameterException("Parameters did not match key parameters");
                }
            }
            return ecPriv;
        }

        @Override
        Pkey checkPublicKey(PublicKey pubKey) throws InvalidKeyException {
            JceEcPublicKey ecPriv = (JceEcPublicKey)this.kf.engineTranslateKey(pubKey);
            return ecPriv.getPkey();
        }
    }

    static final class State
    implements Runnable {
        final byte[] secret;

        State(byte[] secret) {
            this.secret = secret;
        }

        @Override
        public final void run() {
            Util.clearArray(this.secret);
        }
    }
}

