/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi.windows;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class WindowsTruffleNFISupport
extends TruffleNFISupport {
    static void initialize() {
        ImageSingletons.add(TruffleNFISupport.class, (Object)new WindowsTruffleNFISupport());
    }

    private WindowsTruffleNFISupport() {
        super("_errno");
    }

    @Override
    protected CCharPointer strdupImpl(CCharPointer src) {
        return WindowsLibC.strdup((CCharPointer)src);
    }

    @Override
    protected long loadLibraryImpl(long nativeContext, String name, int flags) {
        String dllPath = name;
        CTypeConversion.CCharPointerHolder dllpathPin = CTypeConversion.toCString((CharSequence)dllPath);
        CCharPointer dllPathPtr = dllpathPin.get();
        WinBase.HMODULE dlhandle = LibLoaderAPI.LoadLibraryA((CCharPointer)dllPathPtr);
        if (dlhandle.isNull()) {
            CompilerDirectives.transferToInterpreter();
            throw (AbstractTruffleException)SubstrateUtil.cast((Object)new Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError(WindowsUtils.lastErrorString((String)dllPath)), AbstractTruffleException.class);
        }
        return dlhandle.rawValue();
    }

    @Override
    protected void freeLibraryImpl(long library) {
        LibLoaderAPI.FreeLibrary((WinBase.HMODULE)((WinBase.HMODULE)WordFactory.pointer((long)library)));
    }

    @Override
    protected long lookupImpl(long nativeContext, long library, String name) {
        PointerBase ret;
        PlatformNativeLibrarySupport nativeLibrarySupport = PlatformNativeLibrarySupport.singleton();
        if (library == 0L) {
            ret = nativeLibrarySupport.findBuiltinSymbol(name);
        } else {
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                ret = LibLoaderAPI.GetProcAddress((WinBase.HMODULE)((WinBase.HMODULE)WordFactory.pointer((long)library)), (CCharPointer)symbol.get());
            }
        }
        if (ret.isNull()) {
            CompilerDirectives.transferToInterpreter();
            throw (AbstractTruffleException)SubstrateUtil.cast((Object)new Target_com_oracle_truffle_nfi_backend_libffi_NFIUnsatisfiedLinkError(WindowsUtils.lastErrorString((String)name)), AbstractTruffleException.class);
        }
        return ret.rawValue();
    }
}

