/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.diagnosticsagent;

import com.oracle.svm.diagnosticsagent.NativeImageDiagnosticsAgent;
import com.oracle.svm.jvmtiagentbase.JvmtiAgentBase;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class ClinitGenerationVisitor
extends ClassVisitor {
    private boolean hasClinit = false;
    private boolean shouldInstrument = true;

    public ClinitGenerationVisitor(int api, ClassWriter writer) {
        super(api, writer);
    }

    public boolean didGeneration() {
        return this.shouldInstrument && !this.hasClinit;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        NativeImageDiagnosticsAgent agent = (NativeImageDiagnosticsAgent)JvmtiAgentBase.singleton();
        this.shouldInstrument = agent.advisor.shouldTraceClassInitialization(name.replace("/", "."));
    }

    @Override
    public void visitEnd() {
        if (!this.hasClinit) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitInsn(177);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        boolean isClinitMethod = "<clinit>".equals(name);
        this.hasClinit = this.hasClinit || isClinitMethod;
        return methodVisitor;
    }
}

