/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.common;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class ToolkitProperties {
    private static final String JIPHER_USER_DIR_PROPERTY = "jipher.user.dir";
    private static final String JIPHER_INSTALL_DIR_PROPERTY = "jipher.install.dir";
    private static final String JIPHER_FIPS_DIR_PROPERTY = "jipher.fips.dir";
    private static final String JIPHER_FIPS_ENFORCEMENT_PROPERTY = "jipher.fips.enforcement";
    private static final String JIPHER_TMP_DIR_PROPERTY_DEFAULT = "java.io.tmpdir";
    private static final String JIPHER_USER_DIR_VALUE = ToolkitProperties.systemProperty("jipher.user.dir", ToolkitProperties.systemProperty("java.io.tmpdir"));
    private static final String JIPHER_INSTALL_DIR_VALUE = ToolkitProperties.systemProperty("jipher.install.dir");
    private static final String JIPHER_FIPS_DIR_VALUE = ToolkitProperties.systemProperty("jipher.fips.dir");
    private static final String JIPHER_FIPS_ENFORCEMENT_VALUE = ToolkitProperties.systemProperty("jipher.fips.enforcement", "FIPS");
    private static final String USER_NAME = ToolkitProperties.systemProperty("user.name");
    private static final String JAVA_LIBRARY_PATH = ToolkitProperties.systemProperty("java.library.path");

    private ToolkitProperties() {
    }

    private static String systemProperty(final String property) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
    }

    private static String systemProperty(String property, String defaultVal) {
        String val = ToolkitProperties.systemProperty(property);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getJipherUserDir() {
        return JIPHER_USER_DIR_VALUE;
    }

    public static String getJipherInstallDir() {
        return JIPHER_INSTALL_DIR_VALUE;
    }

    public static String getFipsModuleDir() {
        return JIPHER_FIPS_DIR_VALUE;
    }

    public static String getJavaLibraryPath() {
        return JAVA_LIBRARY_PATH;
    }

    public static String getFipsEnforcementValue() {
        return JIPHER_FIPS_ENFORCEMENT_VALUE;
    }
}

