/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.common.Debug;
import com.oracle.jipher.internal.loader.FileUtil;
import com.oracle.jipher.internal.loader.LibraryLoaderContext;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

class TempLibraryCleaner {
    private static final Debug DEBUG = Debug.getInstance("jipher");
    private final LibraryLoaderContext loaderContext;
    private final FileUtil fileUtil;

    TempLibraryCleaner(LibraryLoaderContext loaderContext) {
        this.loaderContext = loaderContext;
        this.fileUtil = new FileUtil(loaderContext.getPlatform());
    }

    void cleanupDirs() {
        try {
            Path libtmpPath = Paths.get(this.loaderContext.getLibTmpDir(), new String[0]);
            if (!Files.exists(libtmpPath, new LinkOption[0]) || !Files.isDirectory(libtmpPath, new LinkOption[0])) {
                DEBUG.println("No directories to clean");
                return;
            }
            List<String> libFileNames = this.loaderContext.getPlatform().getLibFiles();
            DirectoryStream.Filter<Path> jipherTmpFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) {
                    try {
                        return Files.isDirectory(entry, new LinkOption[0]) && entry.getFileName().toString().startsWith(TempLibraryCleaner.this.loaderContext.getRandomDirPrefix());
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            };
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(libtmpPath, (DirectoryStream.Filter<? super Path>)jipherTmpFilter);){
                for (Path dir : ds) {
                    DEBUG.println("Cleaning " + dir);
                    Path ldg = dir.resolve("jipher.ldg");
                    if (!Files.exists(ldg, new LinkOption[0])) {
                        for (String libFile : libFileNames) {
                            Path lib = dir.resolve(libFile);
                            DEBUG.println("Deleting " + lib);
                            try {
                                Files.deleteIfExists(lib);
                            }
                            catch (IOException e) {
                                DEBUG.println("Failed to delete " + lib + ":" + e.toString());
                            }
                        }
                    } else {
                        DEBUG.println("No attempt to delete since " + ldg + " exists");
                    }
                    this.fileUtil.tryDelete(dir);
                }
            }
        }
        catch (Exception e) {
            DEBUG.println("Caught exception trying to cleanup: " + e.getMessage());
        }
    }
}

