/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.AlgType;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.OsslObject;
import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public final class CipherCtx
extends OsslObject {
    private static final int EVP_CTRL_AEAD_GET_TAG = 16;
    private static final int EVP_CTRL_AEAD_SET_TAG = 17;
    private static final ConcurrentMap<String, Long> PREFETCHED_CIPHERS = new ConcurrentHashMap<String, Long>();
    private boolean encrypting;

    public CipherCtx() {
        super(CipherCtx.newState());
    }

    static State newState() {
        OpenSsl openssl = OsslFactory.get();
        try {
            return new State(openssl, openssl.evpCipherCtxNew());
        }
        catch (OpenSslException e) {
            throw new ProviderException("Failed to create OpenSSL object", e);
        }
    }

    static void clearPrefetchCache() {
        PREFETCHED_CIPHERS.clear();
    }

    long fetch(String cipherAlg) {
        try {
            return this.openssl.evpFetch(AlgType.CIPHER.ordinal(), cipherAlg);
        }
        catch (OpenSslException e) {
            throw new ProviderException("Internal error", e);
        }
    }

    public void init(String cipherAlg, boolean padding, boolean encrypt, byte[] key, byte[] iv) throws InvalidAlgorithmParameterException {
        long evpCipher = PREFETCHED_CIPHERS.computeIfAbsent(cipherAlg, alg -> this.fetch((String)alg));
        try {
            this.openssl.evpCipherInitEx(this, evpCipher, encrypt, key, iv, padding);
            this.encrypting = encrypt;
        }
        catch (OpenSslException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    public int update(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        try {
            return this.openssl.evpCipherUpdate(this, in, inOff, inLen, out, outOff);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public void updateAad(byte[] in, int inOff, int inLen) {
        try {
            this.openssl.evpCipherUpdateAadEx(this, in, inOff, inLen);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public int doFinal(byte[] out, int offset) throws BadPaddingException, IllegalBlockSizeException {
        try {
            return this.openssl.evpCipherFinal(this, out, offset);
        }
        catch (OpenSslException e) {
            if (this.encrypting) {
                IllegalBlockSizeException ibse = new IllegalBlockSizeException(e.getMessage());
                ibse.initCause(e);
                throw ibse;
            }
            BadPaddingException bpe = new BadPaddingException(e.getMessage());
            bpe.initCause(e);
            throw bpe;
        }
    }

    public void setAuthTag(byte[] tag, int offset, int len) {
        try {
            this.openssl.evpCipherCtxCtrl(this, 17, len, tag, offset, true);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public void getAuthTag(byte[] out, int offset, int len) {
        try {
            this.openssl.evpCipherCtxCtrl(this, 16, len, out, offset, false);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    static class State
    extends OsslObject.BaseState {
        State(OpenSsl openssl, long ptr) {
            super(openssl, ptr);
        }

        @Override
        void free(long ptr) {
            this.openssl.evpCipherCtxFree(ptr);
        }
    }
}

