/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.MdCtx;
import java.security.MessageDigestSpi;

public abstract class Digest
extends MessageDigestSpi
implements Cloneable {
    private MdCtx.Digest ctx;
    private final MdAlg alg;
    private final int digestLen;

    Digest(MdAlg mdAlg, int digestLen) {
        this.digestLen = digestLen;
        this.alg = mdAlg;
    }

    @Override
    protected void engineReset() {
        this.cleanup();
    }

    @Override
    protected void engineUpdate(byte input) {
        this.engineUpdate(new byte[]{input}, 0, 1);
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLen;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.initializeIfRequired();
        this.ctx.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        this.initializeIfRequired();
        try {
            byte[] output = new byte[this.digestLen];
            this.ctx.digest(output, 0);
            byte[] byArray = output;
            return byArray;
        }
        finally {
            this.cleanup();
        }
    }

    private void initializeIfRequired() {
        if (this.ctx == null) {
            this.ctx = new MdCtx.Digest();
            this.ctx.init(this.alg);
        }
    }

    private void cleanup() {
        if (this.ctx != null) {
            this.ctx.free();
            this.ctx = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Digest clone = (Digest)super.clone();
        if (this.ctx != null) {
            clone.ctx = this.ctx.copy();
        }
        return clone;
    }

    public static final class Sha3_512
    extends Digest {
        public Sha3_512() {
            super(MdAlg.SHA3_512, 64);
        }
    }

    public static final class Sha3_384
    extends Digest {
        public Sha3_384() {
            super(MdAlg.SHA3_384, 48);
        }
    }

    public static final class Sha3_256
    extends Digest {
        public Sha3_256() {
            super(MdAlg.SHA3_256, 32);
        }
    }

    public static final class Sha3_224
    extends Digest {
        public Sha3_224() {
            super(MdAlg.SHA3_224, 28);
        }
    }

    public static final class Sha512
    extends Digest {
        public Sha512() {
            super(MdAlg.SHA512, 64);
        }
    }

    public static final class Sha384
    extends Digest {
        public Sha384() {
            super(MdAlg.SHA384, 48);
        }
    }

    public static final class Sha256
    extends Digest {
        public Sha256() {
            super(MdAlg.SHA256, 32);
        }
    }

    public static final class Sha224
    extends Digest {
        public Sha224() {
            super(MdAlg.SHA224, 28);
        }
    }

    public static final class Sha1
    extends Digest {
        public Sha1() {
            super(MdAlg.SHA1, 20);
        }
    }
}

