/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.InternalTlsSpec;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private InternalTlsSpec.PrfParameterSpec paramSpec;
    private MdAlg md;

    @Override
    protected void engineInit(int keySize, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        InternalTlsSpec.PrfParameterSpec pSpec = new InternalTlsSpec.PrfParameterSpec(algorithmParameterSpec);
        SecretKey key = pSpec.getSecret();
        if (key != null && !"RAW".equals(key.getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
        this.md = MdAlg.byName(pSpec.getPRFHashAlg());
        if (this.md == null) {
            throw new InvalidAlgorithmParameterException("Unsupported PRF hash algorithm");
        }
        this.paramSpec = pSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        SecretKeySpec secretKeySpec;
        if (this.paramSpec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        SecretKey key = this.paramSpec.getSecret();
        byte[] secret = key == null ? null : key.getEncoded();
        byte[] prfBytes = null;
        try {
            prfBytes = EvpKdf.tls1PrfDerive(secret, this.paramSpec.getLabel().getBytes(UTF8), this.paramSpec.getSeed(), null, this.md, this.paramSpec.getOutputLength());
            secretKeySpec = new SecretKeySpec(prfBytes, "TlsPrf");
        }
        catch (Throwable throwable) {
            Util.clearArray(secret);
            Util.clearArray(prfBytes);
            throw throwable;
        }
        Util.clearArray(secret);
        Util.clearArray(prfBytes);
        return secretKeySpec;
    }
}

