/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.x509;

import com.oracle.jipher.pki.x509.X509ExtnValue;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1Exception;
import com.oracle.jipher.tools.asn1.UniversalTag;
import java.security.cert.X509Extension;

public final class SubjectKeyId
implements X509ExtnValue {
    private static final String OID = "2.5.29.14";
    private byte[] encoding;
    private byte[] keyId;

    private SubjectKeyId(byte[] encoding, byte[] keyId) {
        this.encoding = encoding;
        this.keyId = keyId;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoding.clone();
    }

    public byte[] getKeyId() {
        return (byte[])this.keyId.clone();
    }

    public static SubjectKeyId decode(X509Extension x509Object) {
        byte[] value = x509Object.getExtensionValue(OID);
        if (value == null) {
            return null;
        }
        try {
            byte[] keyIdDer = Asn1.decodeOne(value).tag(UniversalTag.OCTET_STRING).getOctetString();
            byte[] idBytes = Asn1.decodeOne(keyIdDer).tag(UniversalTag.OCTET_STRING).getOctetString();
            return new SubjectKeyId(keyIdDer, idBytes);
        }
        catch (Asn1Exception e) {
            throw new IllegalArgumentException("Object contained invalid SubjectKeyId extension.");
        }
    }
}

