/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.Objects;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
public @interface Uninterruptible {
    public static final String CALLED_FROM_UNINTERRUPTIBLE_CODE = "Called from uninterruptible code.";

    public String reason();

    public boolean callerMustBe() default false;

    public boolean calleeMustBe() default true;

    public boolean mayBeInlined() default false;

    public static class Utils {
        private static final int SYNTHETIC = 4096;
        private static final Uninterruptible NO_TRANSITION = Objects.requireNonNull(Utils.getAnnotation(ReflectionUtil.lookupMethod(Utils.class, (String)"noTransitionHolder", (Class[])new Class[0])));

        @Uninterruptible(reason="@CFunction / @InvokeCFunctionPointer with Transition.NO_TRANSITION")
        private static void noTransitionHolder() {
        }

        public static Uninterruptible getAnnotation(AnnotatedElement method) {
            boolean isSynthetic;
            if (method instanceof Executable) {
                isSynthetic = (((Executable)method).getModifiers() & 0x1000) != 0;
            } else if (method instanceof ResolvedJavaMethod) {
                isSynthetic = ((ResolvedJavaMethod)method).isSynthetic();
            } else {
                throw VMError.shouldNotReachHere("Unexpected method implementation class: " + method.getClass().getTypeName());
            }
            if (isSynthetic) {
                return null;
            }
            Uninterruptible annotation = (Uninterruptible)AnnotationAccess.getAnnotation((AnnotatedElement)method, Uninterruptible.class);
            if (annotation != null) {
                return annotation;
            }
            CFunction cFunctionAnnotation = (CFunction)AnnotationAccess.getAnnotation((AnnotatedElement)method, CFunction.class);
            InvokeCFunctionPointer cFunctionPointerAnnotation = (InvokeCFunctionPointer)AnnotationAccess.getAnnotation((AnnotatedElement)method, InvokeCFunctionPointer.class);
            if (cFunctionAnnotation != null && cFunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || cFunctionPointerAnnotation != null && cFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION) {
                return NO_TRANSITION;
            }
            return null;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static boolean isUninterruptible(AnnotatedElement method) {
            return Utils.getAnnotation(method) != null;
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static boolean inliningAllowed(AnnotatedElement caller, AnnotatedElement callee) {
            boolean callerUninterruptible = Utils.isUninterruptible(caller);
            boolean calleeUninterruptible = Utils.isUninterruptible(callee);
            if (callerUninterruptible) {
                return calleeUninterruptible;
            }
            if (!calleeUninterruptible) {
                return true;
            }
            Uninterruptible calleeUninterruptibleAnnotation = (Uninterruptible)AnnotationAccess.getAnnotation((AnnotatedElement)callee, Uninterruptible.class);
            return calleeUninterruptibleAnnotation != null && calleeUninterruptibleAnnotation.mayBeInlined();
        }
    }
}

