/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.stackvalue.StackValueRecursionDepthPhase;
import com.oracle.svm.core.graal.stackvalue.StackValueSlotAssignmentPhase;
import com.oracle.svm.core.graal.stackvalue.StackValueSnippets;
import java.util.ListIterator;
import java.util.Map;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;

@AutomaticallyRegisteredFeature
public class StackValueFeature
implements InternalFeature {
    @Override
    public void registerGraalPhases(Providers providers, SnippetReflectionProvider snippetReflection, Suites suites, boolean hosted) {
        ListIterator midTierPos = suites.getMidTier().findPhase(FrameStateAssignmentPhase.class);
        midTierPos.previous();
        midTierPos.add(new StackValueRecursionDepthPhase());
        ListIterator lowTierPos = suites.getLowTier().findPhase(LoweringPhase.class);
        lowTierPos.next();
        lowTierPos.add(new StackValueSlotAssignmentPhase());
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(StackValueSnippets.FOREIGN_CALLS);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (hosted) {
            new StackValueSnippets(options, providers, lowerings);
        }
    }
}

