/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileDescriptor;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.MappedByteBuffer;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.ZipFile;
import jdk.internal.ref.CleanerFactory;

public final class DisallowedImageHeapObjects {
    private static final Class<?> CANCELLABLE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"sun.nio.fs.Cancellable");
    private static final Class<?> JDK_VIRTUAL_THREAD_CLASS = ReflectionUtil.lookupClass((boolean)true, (String)"java.lang.VirtualThread");
    private static final Class<?> CONTINUATION_CLASS = ReflectionUtil.lookupClass((boolean)true, (String)"jdk.internal.vm.Continuation");
    private static final Method CONTINUATION_IS_STARTED_METHOD = CONTINUATION_CLASS == null ? null : ReflectionUtil.lookupMethod(CONTINUATION_CLASS, (String)"isStarted", (Class[])new Class[0]);
    private static final Class<?> CLEANER_CLEANABLE_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.ref.CleanerImpl$CleanerCleanable");
    private static final Class<?> LEGACY_CLEANER_CLASS = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.ref.Cleaner");
    private static final Field FILE_DESCRIPTOR_FIELD = ReflectionUtil.lookupField(MappedByteBuffer.class, (String)"fd");

    public static void check(Object obj, DisallowedObjectReporter reporter) {
        FileDescriptor asFileDescriptor;
        if (obj instanceof Random && !(obj instanceof ThreadLocalRandom) || obj instanceof SplittableRandom) {
            throw reporter.raise("Detected an instance of Random/SplittableRandom class in the image heap. Instances created during image generation have cached seed values and don't behave as expected.", obj, "Try avoiding to initialize the class that caused initialization of the object.");
        }
        if (obj instanceof Thread) {
            Thread asThread = (Thread)obj;
            if (!(VirtualThreads.isSupported() && (VirtualThreads.singleton().isVirtual(asThread) || JDK_VIRTUAL_THREAD_CLASS != null && JDK_VIRTUAL_THREAD_CLASS.isInstance(asThread)) || asThread.getState() == Thread.State.NEW || asThread.getState() == Thread.State.TERMINATED)) {
                throw reporter.raise("Detected a started Thread in the image heap. Thread name: " + asThread.getName() + ". Threads running in the image generator are no longer running at image runtime.", asThread, "Prevent threads from starting during image generation, or a started thread from being included in the image.");
            }
        }
        if (SubstrateUtil.HOSTED && CONTINUATION_CLASS != null && CONTINUATION_CLASS.isInstance(obj)) {
            boolean isStarted;
            try {
                isStarted = (Boolean)CONTINUATION_IS_STARTED_METHOD.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                isStarted = false;
            }
            if (isStarted) {
                throw reporter.raise("Detected a started Continuation in the image heap. Continuation state from the image generator cannot be used at image runtime.", obj, "Prevent continuations from starting during image generation, or started continuations from being included in the image.");
            }
        }
        if (obj instanceof FileDescriptor && (asFileDescriptor = (FileDescriptor)obj) != FileDescriptor.in && asFileDescriptor != FileDescriptor.out && asFileDescriptor != FileDescriptor.err && asFileDescriptor.valid()) {
            throw reporter.raise("Detected a FileDescriptor in the image heap. File descriptors opened during image generation are no longer open at image runtime, and the files might not even be present anymore at image runtime.", asFileDescriptor, "Try avoiding to initialize the class that caused initialization of the FileDescriptor.");
        }
        if (obj instanceof MappedByteBuffer) {
            MappedByteBuffer buffer = (MappedByteBuffer)obj;
            if (buffer.capacity() != 0 || DisallowedImageHeapObjects.getFileDescriptor(buffer) != null) {
                throw reporter.raise("Detected a direct/mapped ByteBuffer in the image heap. A direct ByteBuffer has a pointer to unmanaged C memory, and C memory from the image generator is not available at image runtime. A mapped ByteBuffer references a file descriptor, which is no longer open and mapped at run time.", buffer, "Try avoiding to initialize the class that caused initialization of the MappedByteBuffer.");
            }
        } else if (obj instanceof Buffer && ((Buffer)obj).isDirect()) {
            throw reporter.raise("Detected a direct Buffer in the image heap. A direct Buffer has a pointer to unmanaged C memory, and C memory from the image generator is not available at image runtime.", obj, "Try avoiding to initialize the class that caused initialization of the direct Buffer.");
        }
        if (!(!(obj instanceof Cleaner.Cleanable) && !LEGACY_CLEANER_CLASS.isInstance(obj) || obj instanceof Reference && ((Reference)obj).refersTo(null) || CLEANER_CLEANABLE_CLASS.isInstance(obj))) {
            throw reporter.raise("Detected an active instance of Cleanable or jdk.internal.ref.Cleaner in the image heap. This usually means that a resource such as a Timer, native memory, a file descriptor or another resource is reachable which is not available at image runtime.", obj, "Prevent such objects being used during image generation, including by class initializers.");
        }
        if (obj instanceof Cleaner && obj != CleanerFactory.cleaner()) {
            throw reporter.raise("Detected a java.lang.ref.Cleaner object in the image heap which uses a daemon thread that invokes cleaning actions, but threads running in the image generator are no longer running at image runtime.", obj, "Prevent such objects being used during image generation, including by class initializers.");
        }
        if (obj instanceof ZipFile) {
            throw reporter.raise("Detected a ZipFile object in the image heap. A ZipFile object contains pointers to unmanaged C memory and file descriptors, and these resources are no longer available at image runtime.", obj, "Try avoiding to initialize the class that caused initialization of the ZipFile.");
        }
        if (CANCELLABLE_CLASS.isInstance(obj)) {
            throw reporter.raise("Detected an instance of a class that extends " + CANCELLABLE_CLASS.getTypeName() + ": " + obj.getClass().getTypeName() + ". It contains a pointer to unmanaged C memory, which is no longer available at image runtime.", obj, "Try avoiding to initialize the class that caused initialization of the object.");
        }
    }

    private static FileDescriptor getFileDescriptor(MappedByteBuffer buffer) {
        try {
            return (FileDescriptor)FILE_DESCRIPTOR_FIELD.get(buffer);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static interface DisallowedObjectReporter {
        public RuntimeException raise(String var1, Object var2, String var3);
    }
}

