/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK19OrLater;
import com.oracle.svm.core.jdk.JDK20OrEarlier;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jdk.localization.substitutions.Target_java_nio_charset_Charset;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.charset.Charset;
import java.util.function.BooleanSupplier;
import jdk.internal.util.StaticProperty;

@Substitute
@TargetClass(value=StaticProperty.class)
final class Target_jdk_internal_util_StaticProperty {
    Target_jdk_internal_util_StaticProperty() {
    }

    @Substitute
    private static String javaHome() {
        return null;
    }

    @Substitute
    private static String userHome() {
        return SystemPropertiesSupport.singleton().userHome();
    }

    @Substitute
    private static String userDir() {
        return SystemPropertiesSupport.singleton().userDir();
    }

    @Substitute
    private static String userName() {
        return SystemPropertiesSupport.singleton().userName();
    }

    @Substitute
    private static String javaIoTmpDir() {
        return SystemPropertiesSupport.singleton().javaIoTmpDir();
    }

    @Substitute
    private static String javaLibraryPath() {
        return SystemPropertiesSupport.singleton().javaLibraryPath();
    }

    @Substitute
    private static String sunBootLibraryPath() {
        String value = SystemPropertiesSupport.singleton().savedProperties.get("sun.boot.library.path");
        return value == null ? "" : value;
    }

    @Substitute
    private static String jdkSerialFilter() {
        return SystemPropertiesSupport.singleton().savedProperties.get("jdk.serialFilter");
    }

    @Substitute
    @TargetElement(onlyWith={StaticPropertyJdkSerialFilterFactoryAvailable.class})
    private static String jdkSerialFilterFactory() {
        return SystemPropertiesSupport.singleton().savedProperties.get("jdk.serialFilterFactory");
    }

    @Substitute
    public static String nativeEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("native.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String fileEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("file.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String javaPropertiesDate() {
        return SystemPropertiesSupport.singleton().savedProperties.getOrDefault("java.properties.date", null);
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class})
    public static String jnuEncoding() {
        return SystemPropertiesSupport.singleton().savedProperties.get("sun.jnu.encoding");
    }

    @Substitute
    @TargetElement(onlyWith={JDK19OrLater.class, JDK20OrEarlier.class})
    public static Charset jnuCharset() {
        String jnuEncoding = SystemPropertiesSupport.singleton().savedProperties.get("sun.jnu.encoding");
        return Target_java_nio_charset_Charset.forName(jnuEncoding, Charset.defaultCharset());
    }

    private static class StaticPropertyJdkSerialFilterFactoryAvailable
    extends StaticPropertyMethodAvailable {
        protected StaticPropertyJdkSerialFilterFactoryAvailable() {
            super("jdkSerialFilterFactory");
        }
    }

    private static abstract class StaticPropertyMethodAvailable
    implements BooleanSupplier {
        private final String methodName;

        protected StaticPropertyMethodAvailable(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public boolean getAsBoolean() {
            return ReflectionUtil.lookupMethod((boolean)true, StaticProperty.class, (String)this.methodName, (Class[])new Class[0]) != null;
        }
    }
}

