/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class ChunkBasedCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    @Fold
    public static ChunkBasedCommittedMemoryProvider get() {
        return (ChunkBasedCommittedMemoryProvider)ImageSingletons.lookup(CommittedMemoryProvider.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord nbytes, UnsignedWord alignment) {
        return this.allocate(nbytes, alignment, false);
    }

    public Pointer allocateUnalignedChunk(UnsignedWord nbytes) {
        return this.allocate(nbytes, ChunkBasedCommittedMemoryProvider.getAlignmentForUnalignedChunks(), false);
    }

    public boolean areUnalignedChunksZeroed() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        this.free(start, nbytes);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase start, UnsignedWord nbytes) {
        this.free(start, nbytes);
    }

    @Fold
    protected static UnsignedWord getAlignmentForUnalignedChunks() {
        int alignment = Math.max(ConfigurationValues.getTarget().wordSize, ConfigurationValues.getObjectLayout().getAlignment());
        return WordFactory.unsigned((int)alignment);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void afterGarbageCollection() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
    }
}

