/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class PosixVirtualMemoryProvider
implements VirtualMemoryProvider {
    protected static final int NO_FD = -1;
    protected static final int NO_FD_OFFSET = 0;
    private static final CGlobalData<WordPointer> CACHED_PAGE_SIZE = CGlobalDataFactory.createWord();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getPageSize() {
        Word value = (Word)CACHED_PAGE_SIZE.get().read();
        if (value.equal((Word)WordFactory.zero())) {
            long queried = Unistd.NoTransitions.sysconf(Unistd._SC_PAGE_SIZE());
            value = (Word)WordFactory.unsigned((long)queried);
            CACHED_PAGE_SIZE.get().write((WordBase)value);
        }
        return value;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static int accessAsProt(int access) {
        int prot = 0;
        if ((access & 1) != 0) {
            prot |= Mman.PROT_READ();
        }
        if ((access & 2) != 0) {
            prot |= Mman.PROT_WRITE();
        }
        if ((access & 4) != 0) {
            prot |= Mman.PROT_EXEC();
        }
        return prot;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getGranularity() {
        return PosixVirtualMemoryProvider.getPageSize();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer reserve(UnsignedWord nbytes, UnsignedWord alignment, boolean executable) {
        Pointer mappingEnd;
        Pointer clippedEnd;
        if (nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        UnsignedWord granularity = this.getGranularity();
        boolean customAlignment = !UnsignedUtils.isAMultiple(granularity, alignment);
        UnsignedWord mappingSize = nbytes;
        if (customAlignment) {
            mappingSize = mappingSize.add(alignment);
        }
        mappingSize = UnsignedUtils.roundUp(mappingSize, granularity);
        int flags = Mman.MAP_ANON() | Mman.MAP_PRIVATE() | Mman.MAP_NORESERVE();
        assert (!executable || !Platform.includedIn(Platform.MACOS_AARCH64.class)) : "Memory reserved with MAP_JIT cannot be committed with MAP_FIXED later";
        Pointer mappingBegin = Mman.NoTransitions.mmap(WordFactory.nullPointer(), mappingSize, Mman.PROT_NONE(), flags, -1, 0L);
        if (mappingBegin.equal((ComparableWord)Mman.MAP_FAILED())) {
            return (Pointer)WordFactory.nullPointer();
        }
        if (!customAlignment) {
            return mappingBegin;
        }
        Pointer begin = PointerUtils.roundUp((PointerBase)mappingBegin, alignment);
        Pointer clippedBegin = begin.subtract((UnsignedWord)mappingBegin);
        if (clippedBegin.aboveOrEqual(granularity)) {
            Mman.NoTransitions.munmap((PointerBase)mappingBegin, UnsignedUtils.roundDown((UnsignedWord)clippedBegin, granularity));
        }
        if ((clippedEnd = (mappingEnd = mappingBegin.add(mappingSize)).subtract((UnsignedWord)begin.add(nbytes))).aboveOrEqual(granularity)) {
            UnsignedWord rounded = UnsignedUtils.roundDown((UnsignedWord)clippedEnd, granularity);
            Mman.NoTransitions.munmap((PointerBase)mappingEnd.subtract(rounded), rounded);
        }
        return begin;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase start, UnsignedWord nbytes, WordBase fileHandle, UnsignedWord offset, int access) {
        if (start.isNonNull() && !this.isAligned(start) || nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        int flags = Mman.MAP_PRIVATE();
        if (start.isNonNull()) {
            flags |= Mman.MAP_FIXED();
        }
        int fd = (int)fileHandle.rawValue();
        Pointer result = Mman.NoTransitions.mmap(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access), flags, fd, offset.rawValue());
        return result.notEqual((ComparableWord)Mman.MAP_FAILED()) ? result : (Pointer)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase start, UnsignedWord nbytes, int access) {
        Pointer result;
        if (start.isNonNull() && !this.isAligned(start) || nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        int flags = Mman.MAP_ANON() | Mman.MAP_PRIVATE();
        if (start.isNonNull()) {
            flags |= Mman.MAP_FIXED();
        }
        if (Platform.includedIn(Platform.MACOS_AARCH64.class) && (access & 8) != 0) {
            flags |= Mman.MAP_JIT();
        }
        return (result = Mman.NoTransitions.mmap(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access), flags, -1, 0L)).notEqual((ComparableWord)Mman.MAP_FAILED()) ? result : (Pointer)WordFactory.nullPointer();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase start, UnsignedWord nbytes, int access) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        return Mman.NoTransitions.mprotect(start, nbytes, PosixVirtualMemoryProvider.accessAsProt(access));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int uncommit(PointerBase start, UnsignedWord nbytes) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        Pointer result = Mman.NoTransitions.mmap(start, nbytes, Mman.PROT_NONE(), Mman.MAP_FIXED() | Mman.MAP_ANON() | Mman.MAP_PRIVATE() | Mman.MAP_NORESERVE(), -1, 0L);
        return result.notEqual((ComparableWord)Mman.MAP_FAILED()) ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int free(PointerBase start, UnsignedWord nbytes) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        UnsignedWord granularity = this.getGranularity();
        Pointer mappingBegin = PointerUtils.roundDown(start, granularity);
        UnsignedWord mappingSize = UnsignedUtils.roundUp(nbytes, granularity);
        return Mman.NoTransitions.munmap((PointerBase)mappingBegin, mappingSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean isAligned(PointerBase ptr) {
        return ptr.isNonNull() && UnsignedUtils.isAMultiple((UnsignedWord)ptr, this.getGranularity());
    }
}

