/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.serialize;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationUtils;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.util.VMError;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SerializationSupport
implements SerializationRegistry {
    private final Constructor<?> stubConstructor;
    private final Map<SerializationLookupKey, Object> constructorAccessors;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final Set<Class<?>> classes = ConcurrentHashMap.newKeySet();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationSupport(Constructor<?> stubConstructor) {
        this.constructorAccessors = new ConcurrentHashMap<SerializationLookupKey, Object>();
        this.stubConstructor = stubConstructor;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object addConstructorAccessor(Class<?> declaringClass, Class<?> targetConstructorClass, Object constructorAccessor) {
        SerializationLookupKey key = new SerializationLookupKey(declaringClass, targetConstructorClass);
        return this.constructorAccessors.putIfAbsent(key, constructorAccessor);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSerializationTargetClass(Class<?> serializationTargetClass) {
        this.classes.add(serializationTargetClass);
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isRegisteredForSerialization(Class<?> cl) {
        return this.classes.contains(cl);
    }

    @Override
    public Object getSerializationConstructorAccessor(Class<?> rawDeclaringClass, Class<?> rawTargetConstructorClass) {
        Class<?> targetConstructorClass;
        Object constructorAccessor;
        Class<Object> declaringClass = rawDeclaringClass;
        if (declaringClass.getName().contains(LambdaUtils.LAMBDA_CLASS_NAME_SUBSTRING)) {
            declaringClass = SerializedLambda.class;
        }
        if ((constructorAccessor = this.constructorAccessors.get(new SerializationLookupKey(declaringClass, targetConstructorClass = Modifier.isAbstract(declaringClass.getModifiers()) ? this.stubConstructor.getDeclaringClass() : rawTargetConstructorClass))) != null) {
            return constructorAccessor;
        }
        String targetConstructorClassName = targetConstructorClass.getName();
        if (!SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet()) {
            throw VMError.unsupportedFeature("SerializationConstructorAccessor class not found for declaringClass: " + declaringClass.getName() + " (targetConstructorClass: " + targetConstructorClassName + "). Usually adding " + declaringClass.getName() + " to serialization-config.json fixes the problem.");
        }
        MissingSerializationRegistrationUtils.missingSerializationRegistration(declaringClass, "type " + declaringClass.getName() + " with target constructor class: " + targetConstructorClassName);
        return null;
    }

    private static final class SerializationLookupKey {
        private final Class<?> declaringClass;
        private final Class<?> targetConstructorClass;

        private SerializationLookupKey(Class<?> declaringClass, Class<?> targetConstructorClass) {
            assert (declaringClass != null && targetConstructorClass != null);
            this.declaringClass = declaringClass;
            this.targetConstructorClass = targetConstructorClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializationLookupKey that = (SerializationLookupKey)o;
            return this.declaringClass.equals(that.declaringClass) && this.targetConstructorClass.equals(that.targetConstructorClass);
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.targetConstructorClass);
        }
    }

    public static final class StubForAbstractClass
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private StubForAbstractClass() {
        }
    }
}

